/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.sierra.reputation.talon.implementations;

import org.openprivacy.sierra.reputation.talon.components.Payload;
import talon.BaseComponent;
import talon.util.net.URI;

public class OverallMarkupPayload
extends BaseComponent
implements Payload {
    public static final float OPTION_UNRATED = -1.0f;
    public static final float OPTION_TERRIBLE = 0.0f;
    public static final float OPTION_BAD = 1.0f;
    public static final float OPTION_AVERAGE = 2.0f;
    public static final float OPTION_GOOD = 3.0f;
    public static final float OPTION_EXCELLENT = 4.0f;
    public static final URI IDENTIFIER = new URI("http://schemas.openprivacy.org/reputation/markup/overall");
    private URI identifier;
    private float option = -1.0f;

    public byte[] getCanonicalFormat() {
        return Float.toString(this.getOption()).getBytes();
    }

    public URI getIdentifier() {
        return this.identifier;
    }

    public float getOption() {
        return this.option;
    }

    public void init() {
        this.setIdentifier(IDENTIFIER);
    }

    public void setIdentifier(URI uRI) {
        this.identifier = uRI;
    }

    public void setOption(float f) {
        this.option = f;
    }

    public String toString() {
        int n = (int)this.getOption();
        String string = "";
        switch (n) {
            case -1: {
                string = "Unrated";
                break;
            }
            case 0: {
                string = "Terrible";
                break;
            }
            case 1: {
                string = "Bad";
                break;
            }
            case 2: {
                string = "Average";
                break;
            }
            case 3: {
                string = "Good";
                break;
            }
            case 4: {
                string = "Excellent";
                break;
            }
            default: {
                string = "Unknown";
            }
        }
        return String.valueOf(string) + " ( " + this.getOption() + " )";
    }
}

