/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.sierra.rce.talon.implementations;

import org.openprivacy.sierra.factories.ReputationFactory;
import org.openprivacy.sierra.nym.talon.components.Nym;
import org.openprivacy.sierra.query.talon.components.RCEQuery;
import org.openprivacy.sierra.query.talon.implementations.ReferenceRCEQuery;
import org.openprivacy.sierra.rce.talon.components.RCE;
import org.openprivacy.sierra.rce.talon.implementations.BaseRCE;
import org.openprivacy.sierra.rce.talon.implementations.util.ReputationReferenceMap;
import org.openprivacy.sierra.reputation.talon.components.Reference;
import org.openprivacy.sierra.reputation.talon.components.Reputation;
import org.openprivacy.sierra.reputation.talon.implementations.OverallMarkupPayload;
import org.openprivacy.sierra.util.ReputationNotFoundException;
import org.openprivacy.sierra.util.SierraException;
import talon.ComponentFactory;
import talon.TalonException;
import talon.components.Logger;

public class WeightedRCE
extends BaseRCE
implements RCE {
    ReputationReferenceMap map = new ReputationReferenceMap();
    private Nym nym = null;
    private Logger logger = null;
    static /* synthetic */ Class class$org$openprivacy$sierra$reputation$talon$implementations$OverallMarkupPayload;
    static /* synthetic */ Class class$org$openprivacy$sierra$query$talon$implementations$ReferenceRCEQuery;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Nym getNym() {
        return this.nym;
    }

    public Reputation getReputation(RCEQuery rCEQuery) throws SierraException, ReputationNotFoundException {
        if (rCEQuery instanceof ReferenceRCEQuery) {
            Reference reference = ((ReferenceRCEQuery)rCEQuery).getReference();
            Reputation[] reputationArray = this.map.getReputations(reference);
            float f = 0.0f;
            int n = 0;
            while (n < reputationArray.length) {
                OverallMarkupPayload overallMarkupPayload = (OverallMarkupPayload)reputationArray[n].getPayload(OverallMarkupPayload.IDENTIFIER);
                f += overallMarkupPayload.getOption();
                ++n;
            }
            float f2 = 0.0f;
            f2 = reputationArray.length != 0 ? f / (float)reputationArray.length : -1.0f;
            Reputation reputation = ReputationFactory.getInstance();
            reputation.setReference(reference);
            reputation.setNym(this.getNym());
            try {
                OverallMarkupPayload overallMarkupPayload = (OverallMarkupPayload)ComponentFactory.getInstance((Class)(class$org$openprivacy$sierra$reputation$talon$implementations$OverallMarkupPayload != null ? class$org$openprivacy$sierra$reputation$talon$implementations$OverallMarkupPayload : (class$org$openprivacy$sierra$reputation$talon$implementations$OverallMarkupPayload = WeightedRCE.class$("org.openprivacy.sierra.reputation.talon.implementations.OverallMarkupPayload"))));
                overallMarkupPayload.setOption(f2);
                reputation.addPayload(overallMarkupPayload);
            }
            catch (TalonException talonException) {
                throw new SierraException(talonException);
            }
            return reputation;
        }
        throw new SierraException("Query type not supported: " + rCEQuery.getTypeReference().toString());
    }

    public Reputation getReputation(Reference reference) throws SierraException, ReputationNotFoundException {
        try {
            ReferenceRCEQuery referenceRCEQuery = (ReferenceRCEQuery)ComponentFactory.getInstance((Class)(class$org$openprivacy$sierra$query$talon$implementations$ReferenceRCEQuery != null ? class$org$openprivacy$sierra$query$talon$implementations$ReferenceRCEQuery : (class$org$openprivacy$sierra$query$talon$implementations$ReferenceRCEQuery = WeightedRCE.class$("org.openprivacy.sierra.query.talon.implementations.ReferenceRCEQuery"))));
            referenceRCEQuery.setReference(reference);
            return this.getReputation(referenceRCEQuery);
        }
        catch (TalonException talonException) {
            throw new SierraException(talonException);
        }
    }

    public void init() {
        this.logger = this.getLogger();
    }

    public void putReputation(Reputation reputation) throws SierraException {
        this.logger.debug("Putting reputation in store engine: " + reputation.toString());
        this.getStoreEngine().put(reputation);
        this.map.putReputation(reputation);
    }
}

