/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.sierra.query.talon.implementations.simple.util;

import java.util.Enumeration;
import org.openprivacy.sierra.query.talon.implementations.simple.SimpleQueryEngine;
import org.openprivacy.sierra.reputation.talon.components.Payload;
import org.openprivacy.sierra.reputation.talon.components.Reputation;
import org.openprivacy.sierra.reputation.talon.implementations.PropertyManagerPayload;
import org.openprivacy.sierra.util.sql.BaseStatement;
import org.openprivacy.sierra.util.sql.Insert;
import org.openprivacy.sierra.util.sql.Select;
import talon.components.DatabaseConnectionPool;

public class InsertReputation {
    private DatabaseConnectionPool dcp = null;
    private Reputation reputation = null;
    private SimpleQueryEngine sqe = null;
    int table_properties_fk_reputation = -1;

    public InsertReputation(DatabaseConnectionPool databaseConnectionPool, Reputation reputation, SimpleQueryEngine simpleQueryEngine) {
        this.dcp = databaseConnectionPool;
        this.reputation = reputation;
        this.sqe = simpleQueryEngine;
    }

    public void commit() throws Exception {
        Select select = new Select();
        select.setDatabaseConnectionPool(this.dcp).setTable("reputations").addString("uri", this.reputation.getURI().toString());
        select.commit();
        if (!select.getResultSet().next()) {
            this.insertIntoReputationsTable(this.dcp);
            Enumeration enumeration = this.reputation.getPayloads();
            while (enumeration.hasMoreElements()) {
                Payload payload = (Payload)enumeration.nextElement();
                if (this.sqe.supports(payload)) {
                    this.sqe.getLogger().message("Indexing payload: " + payload.getTypeReference());
                    this.insertIntoIdentifiersTable(this.dcp, payload);
                    this.insertIntoPropertiesTable(this.dcp, payload);
                    continue;
                }
                this.sqe.getLogger().warning("The given payload is not supported: " + payload.getTypeReference());
            }
        } else {
            this.sqe.getLogger().warning("The given reputation already is already indexed: " + this.reputation.getURI());
        }
    }

    private void insertIntoIdentifiersTable(DatabaseConnectionPool databaseConnectionPool, Payload payload) throws Exception {
        Select select = new Select();
        select.setDatabaseConnectionPool(databaseConnectionPool).setTable("identifiers").addString("uri", payload.getIdentifier().toString());
        select.commit();
        if (!select.getResultSet().next()) {
            this.sqe.getLogger().message("Adding database record for identifier: " + payload.getIdentifier().toString());
            Insert insert = new Insert();
            insert.setDatabaseConnectionPool(databaseConnectionPool).setTable("identifiers").addString("uri", payload.getIdentifier().toString());
            insert.commit();
        }
    }

    private void insertIntoPropertiesTable(DatabaseConnectionPool databaseConnectionPool, Payload payload) throws Exception {
        Object object;
        int n = -1;
        Select select = new Select();
        select.setDatabaseConnectionPool(databaseConnectionPool).setTable("identifiers").addString("uri", payload.getIdentifier().toString());
        select.commit();
        select.getResultSet().next();
        n = select.getResultSet().getInt("pk");
        if (this.table_properties_fk_reputation == -1) {
            object = new Select();
            ((BaseStatement)object).setDatabaseConnectionPool(databaseConnectionPool).setTable("reputations").addString("uri", payload.getIdentifier().toString());
            ((Select)object).commit();
            ((Select)object).getResultSet().next();
            this.table_properties_fk_reputation = ((Select)object).getResultSet().getInt("pk");
        }
        object = (PropertyManagerPayload)payload;
        Enumeration enumeration = object.getKeys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = object.getProperty(string).toString();
            Insert insert = new Insert();
            insert.setDatabaseConnectionPool(databaseConnectionPool).setTable("properties").addInteger("reputation", this.table_properties_fk_reputation).addInteger("identifier", n).addString("name", string).addString("value", string2).addString("type", "string");
            insert.commit();
        }
    }

    private void insertIntoReputationsTable(DatabaseConnectionPool databaseConnectionPool) throws Exception {
        this.sqe.getLogger().message("Adding database record for reputation: " + this.reputation.getURI().toString());
        Insert insert = new Insert();
        insert.setDatabaseConnectionPool(databaseConnectionPool).setTable("reputations").addString("reference", this.reputation.getReference().toString()).addString("uri", this.reputation.getURI().toString());
        insert.commit();
        Select select = new Select();
        select.setDatabaseConnectionPool(databaseConnectionPool).setTable("reputations").addString("uri", this.reputation.getURI().toString());
        select.commit();
        this.table_properties_fk_reputation = select.getResultSet().getInt("pk");
    }
}

