/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.sierra.query.talon.implementations.simple;

import java.util.Enumeration;
import java.util.Vector;
import org.openprivacy.sierra.query.QueryNotSupportedException;
import org.openprivacy.sierra.query.talon.components.Query;
import org.openprivacy.sierra.query.talon.components.QueryEngine;
import org.openprivacy.sierra.query.talon.components.Result;
import org.openprivacy.sierra.query.talon.components.TargetedQuery;
import org.openprivacy.sierra.query.talon.implementations.simple.util.SelectReputation;
import org.openprivacy.sierra.reputation.talon.components.Payload;
import org.openprivacy.sierra.reputation.talon.components.Reputation;
import org.openprivacy.sierra.util.SierraException;
import org.openprivacy.sierra.util.SierraResources;
import talon.BaseComponent;
import talon.Component;
import talon.ComponentFactory;
import talon.ComponentHandle;
import talon.TalonException;
import talon.components.DatabaseConnectionPool;
import talon.components.Logger;
import talon.components.PropertyManager;
import talon.references.TypeReferenceFactory;
import talon.util.net.URI;

public class SimpleQueryEngine
extends BaseComponent
implements Component,
QueryEngine {
    public static final String SUPPORTED_PAYLOADS_KEY = "supported_payloads";
    private Vector supportedPayloads = new Vector();
    private DatabaseConnectionPool dcp = null;
    private Logger logger = null;
    static /* synthetic */ Class class$org$openprivacy$sierra$reputation$talon$implementations$PropertyManagerPayload;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Result execute(Query query) throws SierraException {
        if (this.supports(query)) {
            this.getLogger().message("Going to execute query: " + query.getTypeReference());
            try {
                SelectReputation selectReputation = new SelectReputation(this.dcp, (PropertyManager)query);
                selectReputation.commit();
                return selectReputation.getResult();
            }
            catch (Throwable throwable) {
                throw new SierraException(throwable);
            }
        }
        throw new QueryNotSupportedException();
    }

    public void init() throws TalonException {
        this.logger = this.getLogger();
        System.out.println("Adding supported payloads...");
        URI uRI = TypeReferenceFactory.getTypeReference((Class)(class$org$openprivacy$sierra$reputation$talon$implementations$PropertyManagerPayload != null ? class$org$openprivacy$sierra$reputation$talon$implementations$PropertyManagerPayload : (class$org$openprivacy$sierra$reputation$talon$implementations$PropertyManagerPayload = SimpleQueryEngine.class$("org.openprivacy.sierra.reputation.talon.implementations.PropertyManagerPayload"))));
        this.supportedPayloads.addElement(uRI);
        this.dcp = (DatabaseConnectionPool)ComponentFactory.getInstance((ComponentHandle)SierraResources.DATABASE_CONNNECTION_POOL);
    }

    public void putReputation(Reputation reputation) throws SierraException {
        this.logger.debug("QueryEngine: putReputation ");
    }

    public boolean supports(Query query) {
        if (query instanceof TargetedQuery) {
            TargetedQuery targetedQuery = (TargetedQuery)query;
            return this.supportedPayloads.contains(targetedQuery.getPayloadIdentifier());
        }
        return false;
    }

    public boolean supports(Payload payload) {
        return this.supportedPayloads.contains(payload.getTypeReference());
    }

    public boolean supports(Reputation reputation) {
        Enumeration enumeration = reputation.getPayloads();
        while (enumeration.hasMoreElements()) {
            Payload payload = (Payload)enumeration.nextElement();
            if (this.supports(payload)) continue;
            return false;
        }
        return true;
    }
}

