---------------------------------------------------------------------------------
--- Last-Modified: $Date: 2001/04/13 19:56:17 $ 
--- Version: $Id: simple.sql,v 1.2 2001/04/13 19:56:17 burton Exp $
--- Author: Kevin A. Burton ( burton@apache.org | burton@openprivacy.org )
---------------------------------------------------------------------------------
--
-- Database creation scripts for MySQL.  This is used to create the necessary 
-- data repository for the org.openprivacy.sierra.store.talon.implementations.simple
--
---------------------------------------------------------------------------------

-- 
-- - how do I create foreign keys with MySQL?  I need to join these tables
--   correctly. 

-- create the database we need for 

-- FIXME: should we use a shorter db name?
create database if not exists sierra_simple;

-- make sure we select the correct db.
use sierra_simple;


-- keep track of property identifier/namespaces.
drop table if exists identifiers;

-- identifiers table holds all payload identifiers.
create table if not exists identifiers 
    ( pk int NOT NULL AUTO_INCREMENT,
      uri varchar(255),
      PRIMARY KEY (pk),
      UNIQUE INDEX indx_pk(pk),
      UNIQUE INDEX indx_tbl_identifiers_col_uri(uri) );

drop table if exists reputations;

create table if not exists reputations
    ( pk int NOT NULL AUTO_INCREMENT,
      reference varchar(250),
      uri varchar(250),
      PRIMARY KEY(pk),
      UNIQUE INDEX indx_pk_tbl_reputations_col_pk(pk),
      INDEX indx_tbl_reputations_col_reference(reference),
      UNIQUE INDEX indx_tbl_reputations_col_uri(uri) );

drop table if exists properties;

--NOTE that column sizes for name and value need to be 250 because mysql can't
-- handle too large of a index.
create table if not exists properties 
    ( pk int NOT NULL AUTO_INCREMENT,
      reputation int NOT NULL, 
      identifier int NOT NULL, 
      name varchar(250),
      value varchar(250),
      type ENUM( 'boolean', 'string' ), 
      PRIMARY KEY(pk),
      KEY(reputation),
      KEY(identifier),
      UNIQUE INDEX indx_pk_tbl_properties_col_pk(pk),
      INDEX indx_fk_tbl_properties_col_reputation(reputation),
       INDEX indx_fk_tbl_properties_col_identifier(identifier),
      INDEX indx_tbl_properties_col_name_col_identifier(name, value) );

show tables;

--select * from identifiers;
