/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $Id: Select.java,v 1.8 2001/06/17 09:37:37 burton Exp $
 * $Project: http://sierra.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 *
 */

package org.openprivacy.sierra.util.sql;


import java.io.*;
import java.net.*;
import java.util.*;
import java.sql.*;
import org.openprivacy.sierra.util.*;
import talon.*;
import talon.components.*;
import talon.util.net.*;

/**
 * <p>
 * This is a simpole database abstraction layer.  It is somewhat like BasePeer
 * from the <a href="http://jakarta.apache.org/turbine">Turbine</a> package but
 * doesn't have any licensing issues.  In the future we should probably choose
 * an alternative.
 *
 * <p>
 * WARNING: This is specifically targeted towards MySql so it might not work on
 * other databases.
 *
 * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
 * @version $Id: Select.java,v 1.8 2001/06/17 09:37:37 burton Exp $
 */
public class Select extends BaseStatement {

    private ResultSet resultSet = null;
    
    /**
     * 
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: Select.java,v 1.8 2001/06/17 09:37:37 burton Exp $
     */
    public void commit() throws Exception {

        //build an SQL insert statement.  
        String select = buildSQLStatement();

        //execute the SQL statement.
        Connection connection = getDatabaseConnectionPool().getConnection();
        
        Statement statement = connection.createStatement();

        ComponentFactory.getLogger().debug( select );
        
        this.resultSet = statement.executeQuery( select );
        
        connection.commit();

        getDatabaseConnectionPool().releaseConnection( connection );
        
    }

    /**
     * 
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: Select.java,v 1.8 2001/06/17 09:37:37 burton Exp $
     */
    public ResultSet getResultSet() {

        return this.resultSet;

    }

    /**
     * Go over all added members and build a valid SQL insert statement.
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: Select.java,v 1.8 2001/06/17 09:37:37 burton Exp $
     */
    private String buildSQLStatement() {

        Vector v = new Vector();

        v = buildSQLStatementVector( getStrings(), v, SelectType.TYPE_STRING );
        v = buildSQLStatementVector( getIntegers(), v, SelectType.TYPE_INTEGER );
        
        return buildSQLStatement( v );
        
    }

    private Vector buildSQLStatementVector( Hashtable hash, Vector vector, int type ) {

        Enumeration keys = hash.keys();

        while ( keys.hasMoreElements() ) {

            String name = (String)keys.nextElement();
            Object value = hash.get( name );

            vector.addElement( new SelectType( type, name, value ) );
        } 

        return vector;
    }
    
    private String buildSQLStatement( Vector criteria ) {

        //dump from the criteria

        StringBuffer buff = new StringBuffer();

        buff.append( "SELECT * FROM " );

        buff.append( getTable() );

        buff.append( " WHERE " );

        for ( int i = 0; i < criteria.size(); ++i ) {

            SelectType st = (SelectType)criteria.elementAt( i );

            buff.append( st.getName() );

            buff.append( " = " );
            
            if ( st.getType() == SelectType.TYPE_STRING )
                buff.append( "'" );

            buff.append( st.getValue().toString() );

            if ( st.getType() == SelectType.TYPE_STRING )
                buff.append( "'" );
            
            
            if ( i < ( criteria.size() - 1 ) ) {
                buff.append( " AND  " );
            } 
            
        } 
        
        buff.append( ";" );
        
        return buff.toString();
        
    }
    
}

class SelectType {

    public static final int TYPE_STRING = 1;
    public static final int TYPE_INTEGER = 2;

    private int type;
    private String name;
    private Object value;
        
    SelectType( int type, String name, Object value ) {

        this.type = type;
        this.name = name;
        this.value = value;
            
    }

    public int getType() { 
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }
        
}

    

