/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $Id: Insert.java,v 1.6 2001/06/17 09:37:37 burton Exp $
 * $Project: http://sierra.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 *
 */

package org.openprivacy.sierra.util.sql;


import java.io.*;
import java.net.*;
import java.util.*;
import java.sql.*;
import org.openprivacy.sierra.util.*;
import talon.*;
import talon.components.*;
import talon.util.net.*;

/**
 * <p>
 * This is a simpole database abstraction layer.  It is somewhat like BasePeer
 * from the <a href="http://jakarta.apache.org/turbine">Turbine</a> package but
 * doesn't have any licensing issues.  In the future we should probably choose
 * an alternative.
 *
 * <p>
 * WARNING: This is specifically targeted towards MySql so it might not work on
 * other databases.
 *
 * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
 * @version $Id: Insert.java,v 1.6 2001/06/17 09:37:37 burton Exp $
 */
public class Insert extends BaseStatement {

    /**
     * 
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: Insert.java,v 1.6 2001/06/17 09:37:37 burton Exp $
     */
    public void commit() throws Exception {

        //build an SQL insert statement.  
        String insert = buildSQLStatement();

        //execute the SQL statement.
        Connection connection = getDatabaseConnectionPool().getConnection();
        
        Statement statement = connection.createStatement();

        ComponentFactory.getLogger().debug( insert );
        
        statement.executeUpdate( insert );

        connection.commit();

        getDatabaseConnectionPool().releaseConnection( connection );

        
    }


    /**
     * Go over all added members and build a valid SQL insert statement.
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: Insert.java,v 1.6 2001/06/17 09:37:37 burton Exp $
     */
    private String buildSQLStatement() {

        StringBuffer buff = new StringBuffer();

        buff.append( "INSERT INTO " );
        buff.append( getTable() );


        //add strings
        Enumeration keys = getStrings().keys();

        buff.append( " ( " );

        while ( keys.hasMoreElements() ) {

            String key = (String)keys.nextElement();

            buff.append( key );

            if ( keys.hasMoreElements() ) {
                buff.append( ", " );
            } 
            
        } 

        //add integers
        Enumeration integerKeys = getIntegers().keys();

        while ( integerKeys.hasMoreElements() ) {

            buff.append( ", " );
            
            String key = (String)integerKeys.nextElement();

            buff.append( key );
            
        } 

        
        
        buff.append( " ) VALUES ( " );        

        Enumeration elements = getStrings().elements();

        while ( elements.hasMoreElements() ) {

            String element = (String)elements.nextElement();

            //strings need to be escaped.
            buff.append("'");
            buff.append( element );
            buff.append("'");
            
            if ( elements.hasMoreElements() ) {
                buff.append( ", " );
            } 
                        
        } 


        //add integers values
        Enumeration integerElements = getIntegers().elements();

        while ( integerElements.hasMoreElements() ) {

            buff.append( ", " );
            
            Integer value = (Integer)integerElements.nextElement();

            buff.append( value.intValue() );
            
        } 

        
        buff.append( " );" );
        
        return buff.toString();
        
    }
    
}

    

