/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $Id: BaseStatement.java,v 1.4 2001/06/17 09:37:37 burton Exp $
 * $Project: http://sierra.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 *
 */

package org.openprivacy.sierra.util.sql;


import java.io.*;
import java.net.*;
import java.util.*;
import java.sql.*;
import org.openprivacy.sierra.util.*;
import talon.*;
import talon.components.*;
import talon.util.net.*;

/**
 * <p>
 * This is a simpole database abstraction layer.  It is somewhat like BasePeer
 * from the <a href="http://jakarta.apache.org/turbine">Turbine</a> package but
 * doesn't have any licensing issues.  In the future we should probably choose
 * an alternative.
 *
 * <p>
 * WARNING: This is specifically targeted towards MySql so it might not work on
 * other databases.
 *
 * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
 * @version $Id: BaseStatement.java,v 1.4 2001/06/17 09:37:37 burton Exp $
 */
public abstract class BaseStatement {

    private String table = null;

    private DatabaseConnectionPool dcp = null;

    private Hashtable strings = new Hashtable();

    private Hashtable integers = new Hashtable();
    
    private String statement = null;

    /**
     * 
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: BaseStatement.java,v 1.4 2001/06/17 09:37:37 burton Exp $
     */
    public BaseStatement setDatabaseConnectionPool( DatabaseConnectionPool dcp ) {

        this.dcp = dcp;
        return this;
        
    }

    /**
     * 
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: BaseStatement.java,v 1.4 2001/06/17 09:37:37 burton Exp $
     */
    public DatabaseConnectionPool getDatabaseConnectionPool() {

        return this.dcp;

    }
    
    /**
     * Set the table this Insert statement will update...
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: BaseStatement.java,v 1.4 2001/06/17 09:37:37 burton Exp $
     */
    public BaseStatement setTable( String table ) {

        this.table = table;
        return this;

    }

    /**
     * Get th table that this Insert statement will operate on.
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: BaseStatement.java,v 1.4 2001/06/17 09:37:37 burton Exp $
     */
    public String getTable() {

        return this.table;

    }

    /**
     * 
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: BaseStatement.java,v 1.4 2001/06/17 09:37:37 burton Exp $
     */
    public BaseStatement addString( String name, String value ) {

        this.strings.put( name, value );
        return this;

    }
    
    public Hashtable getStrings() {
        return this.strings;
    }

    
    /**
     * 
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: BaseStatement.java,v 1.4 2001/06/17 09:37:37 burton Exp $
     */
    public BaseStatement addInteger( String name, int value ) {

        this.integers.put( name, new Integer( value ) );
        return this;

    }
    
    public Hashtable getIntegers() {
        return this.integers;
    }

    
    /**
     * Commit this object
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: BaseStatement.java,v 1.4 2001/06/17 09:37:37 burton Exp $
     */
    public abstract void commit() throws Exception;
    
}

    

