/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $Id: SignatureValue.java,v 1.5 2001/06/17 09:37:37 burton Exp $
 * $Project: http://sierra.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 *
 */

package org.openprivacy.sierra.util;

import java.io.*;
import java.net.*;
import java.util.*;
import java.security.*;
import org.openprivacy.sierra.util.*;
import talon.*;
import talon.components.*;
import talon.util.*;
import talon.util.net.*;

/**
 * Class which can be used to reference a signed document/object somewhere in
 * the universe.  The main data here is thhe pubkey and the bytes of the
 * signature value. 
 * 
 * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
 * @version $Id: SignatureValue.java,v 1.5 2001/06/17 09:37:37 burton Exp $
 */
public class SignatureValue {


    private URI reference = null;
    private byte[] bytes = new byte[0];
    private PublicKey publicKey = null;
    
    /**
     * Points to the object which this is based on.  Note that this may not be
     * available via the network.
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: SignatureValue.java,v 1.5 2001/06/17 09:37:37 burton Exp $
     */
    public URI getReference() { 
        return this.reference;
    }


    /**
     * @see #getReference
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: SignatureValue.java,v 1.5 2001/06/17 09:37:37 burton Exp $
     */
    public void setReference( URI reference ) { 
        this.reference = reference;
    }
    
    /**
     * Get the signature data for the document this points to.
     * 
     * @see #getReference
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: SignatureValue.java,v 1.5 2001/06/17 09:37:37 burton Exp $
     */
    public byte[] getBytes() {

        return this.bytes;

    }
    
    /**
     * @see #getBytes
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: SignatureValue.java,v 1.5 2001/06/17 09:37:37 burton Exp $
     */
    public void setBytes( byte[] bytes ) {
        this.bytes = bytes;
    }

    /**
     * Return the public key necessary to identifiy the signer of this object.
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: SignatureValue.java,v 1.5 2001/06/17 09:37:37 burton Exp $
     */
    public PublicKey getPublicKey() { 
        return this.publicKey;
    }

    /**
     * @see #getPublicKey
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: SignatureValue.java,v 1.5 2001/06/17 09:37:37 burton Exp $
     */
    public void setPublicKey( PublicKey publicKey ) { 
        this.publicKey = publicKey;
    }

    public boolean equals( Object obj ) {

        if ( obj instanceof SignatureValue ) {

            SignatureValue sv = (SignatureValue)obj;

            return Arrays.equals( this.getBytes(), sv.getBytes() );
            
        } else {
            return false;
        }

    }

    public String toString() {
        return new String( Base64.encode( getBytes() ) );
    }

}
