/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $Id: SierraResources.java,v 1.15 2001/06/17 09:37:37 burton Exp $
 * $Project: http://sierra.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 *
 */

package org.openprivacy.sierra.util;

import java.io.*;
import java.net.*;
import java.security.Principal;
import java.util.*;
import org.openprivacy.sierra.rce.talon.components.*;
import org.openprivacy.sierra.reputation.talon.components.*;
import talon.*;
import talon.components.*;
import talon.util.net.*;

/**
 * Responsible for holding all resources need by Sierra as a global application.
 * Also handles serving some objects needed as components but keeps application
 * from dealing with Talon components.
 *
 * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
 * @version $Id: SierraResources.java,v 1.15 2001/06/17 09:37:37 burton Exp $
 */
public class SierraResources {

    /**
     * Default handle for creating a reputation object.
     */
    public static final ComponentHandle REPUTATION_HANDLE =
        new ComponentHandle().setName( "talon:///component-name/product/sierra/name/reputation" );

    /**
     * Default handle for creating a payload object.       
     */
    public static final ComponentHandle PAYLOAD_HANDLE = 
        new ComponentHandle().setName( "talon:///component-name/product/sierra/name/payload" );

    /**
     * Default store manager
     */
    public static final ComponentHandle STORE_MANAGER_HANDLE =
        new ComponentHandle().setName( "talon:///component-name/product/sierra/name/store_manager" );
    
    /**
     * Default store 
     */
    public static final ComponentHandle STORE_ENGINE_HANDLE =
        new ComponentHandle().setName( "talon:///component-name/product/sierra/name/store_engine" );

    /**
     * Default reference
     */
    public static final ComponentHandle REFERENCE_HANDLE =
        new ComponentHandle().setInterface( "org.openprivacy.sierra.reputation.talon.components.Reference" )
                             .setImplementation( "org.openprivacy.sierra.reputation.talon.implementations.SimpleReference" )
                             .setLifetime( ComponentHandle.LIFETIME_DEMAND );

    /**
     * Default RCE
     */
    public static final ComponentHandle RCE_HANDLE =
        new ComponentHandle().setName( "talon:///component-name/product/sierra/name/rce" );
    

    public static final ComponentHandle RCE_CONTEXT_HANDLE = 
        new ComponentHandle().setInterface( "org.openprivacy.sierra.rce.talon.components.RCEContext" )
                             .setImplementation( "org.openprivacy.sierra.rce.talon.implementations.SimpleRCEContext" )
                             .setLifetime( ComponentHandle.LIFETIME_DEMAND );

    public static final ComponentHandle DATABASE_CONNNECTION_POOL =
        new ComponentHandle().setName( "talon:///component-name/product/sierra/name/database_connection_pool" );

    /**
     * Get the registered Talon Component "RCEContext" with a "demand" lifetime.
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: SierraResources.java,v 1.15 2001/06/17 09:37:37 burton Exp $
     */
    public static RCEContext getRCEContext() throws SierraException {

        try {
            return (RCEContext)ComponentFactory.getInstance(SierraResources.RCE_CONTEXT_HANDLE );
        } catch ( TalonException e ) {
            throw new SierraException( e );
        }
        
    }

    
}
