/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $Id: ReputationURIEncoder.java,v 1.2 2001/06/17 09:37:37 burton Exp $
 * $Project: http://sierra.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 *
 */

package org.openprivacy.sierra.util;

import java.io.*;
import java.net.*;
import java.security.*;
import java.util.*;
import org.openprivacy.sierra.reputation.talon.components.*;
import org.openprivacy.sierra.util.*;
import talon.*;
import talon.components.*;
import talon.util.*;
import talon.util.net.*;


/**
 * Responsible for encoding a Reputation object as a URI.
 *
 * @see ReputationDecoder
 * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
 * @version $Id: ReputationURIEncoder.java,v 1.2 2001/06/17 09:37:37 burton Exp $
 */
public class ReputationURIEncoder {

    public static URI encode( Reputation reputation ) throws SierraException {

        return encode( reputation.getSignatureValue() );
        
    }

    public static URI encode( SignatureValue sv ) throws SierraException {

        if ( sv == null ) {
            throw new SierraException( "The given reputation does not have a signature." );
        } 
        
        String key_value = Base64.encode( sv.getPublicKey().getEncoded() );

        String sig_value = Base64.encode( sv.getBytes() );
        
        return new URI( "reputation:///" + key_value + "/" + sig_value );

    }
    
} 
