/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $Id: ReputationURIDecoder.java,v 1.2 2001/06/17 09:37:37 burton Exp $
 * $Project: http://sierra.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 *
 */

package org.openprivacy.sierra.util;

import java.io.*;
import java.net.*;
import java.security.*;
import java.util.*;
import org.openprivacy.sierra.util.*;
import talon.*;
import talon.components.*;
import talon.util.*;
import talon.util.net.*;

/**
 * Responsible for encoding a Reputation object as a URI.
 *
 * @see ReputationEncoder
 * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
 * @version $Id: ReputationURIDecoder.java,v 1.2 2001/06/17 09:37:37 burton Exp $
 */
public class ReputationURIDecoder {

    public static SignatureValue decode( URI uri ) throws SierraException {

        try {
        
            String hash_value = null;
            String uri_value = uri.toString();
        
            //Example reputation we need to decode: reputation:///dXJuOnJlcHRpbGU/3Jg205Bd0lb4knkAbCxNcg

            int begin = "reputation:///".length();

            begin = uri_value.indexOf( "/", begin ) + 1;

            hash_value = uri_value.substring( begin, uri_value.length() );

            SignatureValue sv = new SignatureValue();

            sv.setBytes( Base64.decode( hash_value ) );
        
            return sv;

        } catch ( TalonException te ) {

            throw new SierraException( te );

        }
        
    }
    
} 
