/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $Id: Canonicalizable.java,v 1.3 2001/06/17 09:37:37 burton Exp $
 * $Project: http://sierra.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 *
 */

package org.openprivacy.sierra.util;

import java.io.*;
import java.net.*;
import java.security.Principal;
import java.util.*;
import org.openprivacy.sierra.util.*;
import talon.*;
import talon.components.*;
import talon.util.net.*;

/**
 * <p>
 * In order to sign/encrypt a document it is important to be able to serialize
 * it into a standard form. This interface marks an object which can produce an
 * canonicalization of itself.
 *
 * <p>
 * This does not need to canonicalize to any specific format, the only major
 * criteria is that it just needs to be unique and identical for the same
 * object. 
 *
 * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
 * @version $Id: Canonicalizable.java,v 1.3 2001/06/17 09:37:37 burton Exp $
 */
public interface Canonicalizable {

    /**
     * Get the canonical format for this object.  Note that this will/may change
     * if the object is modified.
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: Canonicalizable.java,v 1.3 2001/06/17 09:37:37 burton Exp $
     */
    public byte[] getCanonicalFormat();
    
}
    


