/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $Id: Test9.java,v 1.21 2001/06/17 09:37:36 burton Exp $
 * $Project: http://sierra.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 *
 */

package org.openprivacy.sierra.tests;


import java.io.*;
import java.net.*;
import java.util.*;
import org.arrowhead.testlet.*;
import org.openprivacy.sierra.factories.*;
import org.openprivacy.sierra.nym.talon.components.*;
import org.openprivacy.sierra.query.talon.implementations.*;
import org.openprivacy.sierra.query.talon.components.*;
import org.openprivacy.sierra.rce.talon.components.*;
import org.openprivacy.sierra.reputation.*;
import org.openprivacy.sierra.reputation.talon.implementations.*;
import org.openprivacy.sierra.reputation.talon.components.*;
import org.openprivacy.sierra.store.talon.components.*;
import org.openprivacy.sierra.util.*;
import talon.*;
import talon.components.*;
import talon.util.net.*;

/**
 * <p>
 * This test implements an Use case one which was defined as:
 * 
 * <p>
 * <b>Definitions:</b>
 * <ul>
 * <li><b>R1:</b>  Reptile agent 1.  Backend engine/server which is an
 * intermediary betwen A1 and A2. 
 * 
 * <li><b>A1:</b>   Agent 1.   First peer into the system.  Sets up initial
 * reputations. 
 * 
 * <li><b>A2:</b>   Agent 2.   Second peer into the system.  Benefits from
 * A1s reptuation(s).
 * 
 * </ul>
 * 
 * <p>
 * <ul>
 * 
 * <li><i>R1:</i> Fetches some RSS channels and creates reputations with
 * these URLs.
 * 
 * <li><i>A1:</i> Does a getReputation request for the RSS channels added byte R1.
 * 
 * <li><i>A2:</i> Does a getReputation request for the RSS channels..
 * 
 * </ul>
 * 
 * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
 * @version $Id: Test9.java,v 1.21 2001/06/17 09:37:36 burton Exp $
 */
public class Test9 extends BaseTest {

    //default RCE to use for all operations
    private RCE rce = null;

    //StoreEngie used by talon
    private StoreEngine se = null;

    private NymBuilder a1 = null;

    private NymBuilder a2 = null;

    private NymBuilder r1 = null;
    
    public void initialize( TestletContext context ) throws Exception {

        //get the basic RCE
        this.rce = (RCE)requireComponent( SierraResources.RCE_HANDLE );

        //get its StoreEngine
        this.se = rce.getStoreEngine();
        
        this.a1 = getNymBuilder( "urn:burtonator" );

        this.a2 = getNymBuilder( "urn:fen" );

        this.r1 = getNymBuilder( "urn:reptile" );
        
        step_one();

        step_two();

        ((org.openprivacy.sierra.store.talon.implementations.simple.SimpleStoreEngine)se).dump();
        
        step_three();
        
    }

    /**
     * Pretend to be Reptile and pull down some RSS channels.
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: Test9.java,v 1.21 2001/06/17 09:37:36 burton Exp $
     */
    public void step_one() throws Exception {

        Reputation channel_one = ReputationFactory.getInstance();

        channel_one.setReference( "http://www.slashdot.org/slashdot.rdf" );
        
        PropertyManagerPayload pmp = getPayload();

        pmp.setString( "openprivacy:///reserved-properties/ontology", "rss" );

        channel_one.addPayload( pmp );
        
        ReputationConstrainer.constrain( channel_one, r1 );

        se.put( channel_one );
        
    }

    /**
     * A1 runs a query to try to find 
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: Test9.java,v 1.21 2001/06/17 09:37:36 burton Exp $
     */
    public void step_two() throws Exception {
        
        //get its QueryManager
        QueryManager qm = se.getQueryManager();

        //build a query
        PropertyManagerTargetedQuery query = (PropertyManagerTargetedQuery)ComponentFactory
            .getInstance( PropertyManagerTargetedQuery.class );

        query.setString( "openprivacy:///reserved-properties/ontology", "rss" );

        //execute a Query.        
        Result result = qm.execute( query );

        //dump the result:
        URI[] reputationURIs = result.getReputations();
        
        for ( int i = 0; i < reputationURIs.length; ++i ) {

            URI current = reputationURIs[i];
            

            Reputation reputation = se.get( current );


            //FIXME: not all reputations will be found here.  This is because
            //the Simple component isn't populated when it starts up.
            
            if ( reputation != null ) {
                System.out.println( "StepTwo: Found reputation URI: " + current );

                createGoodReputation( reputation.getReference() );
            } 
            
        } 
        
    }

    /**
     * Execute a query for all objects that have an ontology of RSS and that are
     * GOOD.
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: Test9.java,v 1.21 2001/06/17 09:37:36 burton Exp $
     */
    public void step_three() throws Exception {

        System.out.println( "Trying to find URLs which have a GOOD reputation." );
        
        //get its QueryManager
        QueryManager qm = se.getQueryManager();

        //build a query
        PropertyManagerTargetedQuery query = (PropertyManagerTargetedQuery)ComponentFactory
            .getInstance( PropertyManagerTargetedQuery.class );

        query.setString( "openprivacy:///reserved-properties/ontology", "rss" );
        query.setString( "openprivacy:///reserved-properties/quality", "GOOD" );
        
        //execute a Query.        
        Result result = qm.execute( query );

        //dump the result:
        URI[] reputationURIs = result.getReputations();

        for ( int i = 0; i < reputationURIs.length; ++i ) {

            URI current = reputationURIs[i];

            System.out.println( "Found the following GOOD reputation: " + current );
            
        }
        
    }

    /**
     * Used with step_two to create a GOOD reptuation for this object.
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: Test9.java,v 1.21 2001/06/17 09:37:36 burton Exp $
     */
    private void createGoodReputation( Reference reference ) throws Exception {

        Reputation opinion = ReputationFactory.getInstance();

        opinion.setReference( reference );

        PropertyManagerPayload pmp = getPayload();

        pmp.setString( "openprivacy:///reserved-properties/quality", "GOOD" );

        opinion.addPayload( pmp );
        
        ReputationConstrainer.constrain( opinion, a1 );

        se.put( opinion );
        
    }
    
    private PropertyManagerPayload getPayload() throws Exception {

        return (PropertyManagerPayload)ComponentFactory
            .getInstance( PropertyManagerPayload.class.getName() );

    }
    
}
