/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $Id: Test8.java,v 1.6 2001/06/17 09:37:36 burton Exp $
 * $Project: http://sierra.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 *
 */

package org.openprivacy.sierra.tests;

import java.io.*;
import java.net.*;
import java.util.*;
import org.arrowhead.testlet.*;
import org.openprivacy.sierra.factories.*;
import org.openprivacy.sierra.nym.talon.components.*;
import org.openprivacy.sierra.reputation.*;
import org.openprivacy.sierra.reputation.talon.components.*;
import org.openprivacy.sierra.util.*;
import talon.*;
import talon.components.*;
import talon.util.net.*;

/**
 * Tries to build a few simple reputations with sample data and test their
 * Reputation URIs.
 *
 * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
 * @version $Id: Test8.java,v 1.6 2001/06/17 09:37:36 burton Exp $
 */
public class Test8 extends BaseTest {

    public void initialize( TestletContext context ) throws Exception {

        //try to grab an example nym.
        NymBuilder nb = getNymBuilder( "urn:burtonator" );


        //build up a reputation
        Reputation reputation = ReputationFactory.getInstance();

        Reference reference = ReferenceFactory.getInstance( "http://www.cnn.com" );

        //constrain the reputation

        ReputationConstrainer.constrain( reputation, nb );
        
        //dump information about the reputation

        System.out.println( "reputation url -> " + reputation.getURI().toString() );
        
    }

}
