/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $Id: Test7.java,v 1.9 2001/06/17 09:37:36 burton Exp $
 * $Project: http://sierra.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 *
 */

package org.openprivacy.sierra.tests;

import java.io.*;
import java.net.*;
import java.util.*;
import org.arrowhead.testlet.*;
import org.openprivacy.sierra.factories.*;
import org.openprivacy.sierra.nym.talon.components.*;
import org.openprivacy.sierra.util.*;
import talon.*;
import talon.components.*;
import talon.util.net.*;

/**
 * Tries to create some nyms and performs basic nym operations, (signing,
 * obtaining the actual Nym, etc).
 *
 * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
 * @version $Id: Test7.java,v 1.9 2001/06/17 09:37:36 burton Exp $
 */
public class Test7 extends BaseTest {

    public void initialize( TestletContext context ) throws Exception {

        //try to grab the current default Nym provider.

        NymBuilder nb = NymBuilderFactory.getInstance( "urn:burtonator" ); 

        Nym nym = nb.getNym();

        NymFunctionProxy nfp = nb.getNymFunctionProxy();

        byte[] signature = nfp.sign( new CanonicalTest() );

        System.out.println( " result == " + signature );
        
    }

    class CanonicalTest implements Canonicalizable {

        public byte[] getCanonicalFormat() {

            return "hello world".getBytes();

        }

    }
    
}
