/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $Id: Test11.java,v 1.4 2001/06/17 09:37:36 burton Exp $
 * $Project: http://sierra.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 *
 */

package org.openprivacy.sierra.tests;

import java.io.*;
import java.net.*;
import java.util.*;
import talon.*;
import talon.util.net.*;
import talon.components.*;
import org.arrowhead.testlet.*;
import org.openprivacy.sierra.*;
import org.openprivacy.sierra.util.*;
import org.openprivacy.sierra.query.*;
import org.openprivacy.sierra.factories.*;
import org.openprivacy.sierra.nym.talon.components.*;
import org.openprivacy.sierra.nym.talon.implementations.*;
import org.openprivacy.sierra.rce.talon.components.*;
import org.openprivacy.sierra.rce.talon.implementations.*;
import org.openprivacy.sierra.reputation.talon.components.*;
import org.openprivacy.sierra.reputation.talon.implementations.*;
import org.openprivacy.sierra.reputation.*;

/**
 * Test of the Weighted RCE.
 *
 * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
 * @version $Id: Test11.java,v 1.4 2001/06/17 09:37:36 burton Exp $
 */
public class Test11 extends BaseTest {

    public static final String REFERENCE = "http://www.slashdot.org/slashdot.rdf";
    
    private NymBuilder a1 = null;

    private NymBuilder a2 = null;

    private RCE rce = null;
    
    public void initialize( TestletContext context ) throws Exception {

        System.out.println( "Testing reference of: " + REFERENCE );
        
        //get the WeightedRCE

        this.rce = RCEFactory.getInstance();
        
        //create some Reputation objects with "OverallMarkup" payloads.
        this.a1 = getNymBuilder( "urn:burtonator" );

        this.a2 = getNymBuilder( "urn:fen" );

        step_one();

        step_two();
        
        System.out.println( "Getting the reputation for: + " + REFERENCE );

        Reputation found = rce.getReputation( ReferenceFactory.getInstance( REFERENCE ) );

        //dump the value...

        OverallMarkupPayload fomp = (OverallMarkupPayload)found.getPayload( OverallMarkupPayload.IDENTIFIER );
        
        System.out.println( "Found option: " + fomp.getOption() );
        
    }

    private void step( NymBuilder nb, float option ) throws Exception {

        //create a reputation for Fen...

        Reputation rep = (Reputation)ComponentFactory
            .getInstance( SierraResources.REPUTATION_HANDLE );

        rep.setReference( REFERENCE );

        OverallMarkupPayload payload = (OverallMarkupPayload)ComponentFactory
            .getInstance( OverallMarkupPayload.class );

        payload.setOption( option );
        
        rep.addPayload( payload );
        
        ReputationConstrainer.constrain( rep, nb );

        System.out.println( "Putting a reputation with a value of: " + option );
        
        rce.putReputation( rep );
        
    }

    private void step_one() throws Exception {

        //create a reputation for Fen...

        step( a1, OverallMarkupPayload.OPTION_GOOD );
        
    }

    private void step_two() throws Exception {

        //create a reputation for Burton...
        step( a2, OverallMarkupPayload.OPTION_BAD );
        
    }

    
}
