/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $Id: BaseTest.java,v 1.14 2001/06/17 09:37:36 burton Exp $
 * $Project: http://sierra.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 *
 */

package org.openprivacy.sierra.tests;

import java.io.*;
import java.net.*;
import java.util.*;
import org.arrowhead.testlet.*;
import org.openprivacy.sierra.factories.*;
import org.openprivacy.sierra.nym.talon.components.*;
import org.openprivacy.sierra.util.*;
import talon.*;
import talon.components.*;
import talon.components.exceptions.*;
import talon.util.net.*;

/**
 * Central location for storing Parameter keys needed by Sierra Unit Tests
 *
 * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
 * @version $Id: BaseTest.java,v 1.14 2001/06/17 09:37:36 burton Exp $
 */
public class BaseTest extends AbstractTestlet {

    public static final String SOAP_RPCROUTER_KEY = "soap.rpcrouter";

    public static final String NYM_BURTONATOR = "urn:burtonator";
    public static final String NYM_FEN = "urn:fen";
    
    /**
     * Quick way to get a nym.
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: BaseTest.java,v 1.14 2001/06/17 09:37:36 burton Exp $
     */
    public Nym getNym( String name ) throws Exception {
        
        return getNymBuilder( name ).getNym();
        
    }

    public NymBuilder getNymBuilder( String name ) throws Exception {


        return NymBuilderFactory.getInstance( name );

    }


    /**
     * 
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: BaseTest.java,v 1.14 2001/06/17 09:37:36 burton Exp $
     */

    public Component requireComponent( ComponentHandle handle ) throws Exception {

        System.out.println( "Trying to require: " + handle.getName() );

        Component comp = null;
        
        try {

            comp = ComponentFactory.getInstance( handle );

        } catch ( Exception rpe ) {

            //NOTE.  There was a bug in early versions of Talon that would not
            //pass on required properties.   This code was added to dump
            //additional ifnormation if that happened.

            System.out.println( "REQUIRED PROPERTIES NOT FOUND" );
            
            System.out.println( rpe.getMessage() );

            HandleManager.dump();

            throw rpe;
        }
            
        comp.getLogger().message( "SUCCESS: " + handle.toString() );
        
        comp.getLogger().message( "\tFound Component with interface: " + handle.getInterface() );
        comp.getLogger().message( "\tFound Component with implementation: " + comp.getClass().getName() );

        return comp;
    }
    
}

    
