/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $Id: SimpleStoreManager.java,v 1.5 2001/06/17 09:37:36 burton Exp $
 * $Project: http://sierra.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 *
 */

package org.openprivacy.sierra.store.talon.implementations.simple;

import java.io.*;
import java.net.*;
import java.util.*;
import org.openprivacy.sierra.rce.talon.components.*;
import org.openprivacy.sierra.store.talon.components.*;
import org.openprivacy.sierra.util.*;
import talon.*;
import talon.components.*;
import talon.util.net.*;


/**
 * @see StoreManager 
 * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
 * @version $Id: SimpleStoreManager.java,v 1.5 2001/06/17 09:37:36 burton Exp $
 */
public class SimpleStoreManager extends BaseComponent implements Component, StoreManager {

    /**
     * @see Component
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: SimpleStoreManager.java,v 1.5 2001/06/17 09:37:36 burton Exp $
     */
    public void init() throws TalonException { }
    
    /**
     * @see StoreManager
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: SimpleStoreManager.java,v 1.5 2001/06/17 09:37:36 burton Exp $
     */
    public StoreEngine getStoreEngine( RCE rce ) throws SierraException {

        //just return the default store.  We need to have a enhance mechanism
        //for mapping RCE stores.  
        try {
            return (StoreEngine)ComponentFactory.getInstance( SierraResources.STORE_ENGINE_HANDLE );
        } catch ( TalonException e ) {
            throw new SierraException( e );
        }
    }
    
}

