/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $Id: SimpleStoreEngine.java,v 1.15 2001/08/01 17:19:47 burton Exp $
 * $Project: http://sierra.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 *
 */

package org.openprivacy.sierra.store.talon.implementations.simple;

import java.io.*;
import java.net.*;
import java.security.*;
import java.sql.*;
import java.util.*;

import org.openprivacy.sierra.query.talon.implementations.simple.*;
import org.openprivacy.sierra.query.talon.components.*;
import org.openprivacy.sierra.rce.*;
import org.openprivacy.sierra.rce.talon.components.*;
import org.openprivacy.sierra.reputation.talon.components.*;
import org.openprivacy.sierra.store.talon.components.*;
import org.openprivacy.sierra.util.*;

import talon.*;
import talon.interfaces.*;
import talon.components.*;
import talon.util.net.*;

/**
 * <p>
 * Implements a SimpleStore which doesn't have any optimizations but will
 * function for testing purposes.
 *
 * <p>
 * Sun Feb 18 13:36:28 2001 (burton@relativity.yi.org): initial implementation
 * has no data persistence.  It might be logical in the future to use a simple
 * data persistence mechanism under this object so that it can be restored on
 * sierra restart.
 *
 * dd
 * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
 * @version $Id: SimpleStoreEngine.java,v 1.15 2001/08/01 17:19:47 burton Exp $
 */
public class SimpleStoreEngine extends BaseComponent implements Dumpable,
                                                                Component,
                                                                StoreEngine {


    /**
     * Stores Signature value (String) -> Reputation
     */
    private Hashtable store = new Hashtable();
    
    public void init() throws TalonException {

        //need to get the database connection pool.
        ComponentFactory.getInstance( SierraResources.DATABASE_CONNNECTION_POOL );

    }
    
    /**
     * @see Store
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: SimpleStoreEngine.java,v 1.15 2001/08/01 17:19:47 burton Exp $
     */
    public Reputation get( URI uri ) throws SierraException {

        //build a signature value object. and call get(SignatureValue sv)

        return get( ReputationURIDecoder.decode( uri ) );
        
    }

    /**
     * @see Store
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: SimpleStoreEngine.java,v 1.15 2001/08/01 17:19:47 burton Exp $
     */
    public Reputation get( SignatureValue sv ) throws SierraException {

        Reputation reputation = (Reputation)store.get( sv.toString() );


        //FIXME: should we throw an exception if this isn't found?
        if ( reputation == null ) {
            getLogger().warn( "Unable to find reputation: " + sv.toString() );
        } 
        

        return reputation;

    }
    
    /**
     * @see Store
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: SimpleStoreEngine.java,v 1.15 2001/08/01 17:19:47 burton Exp $
     */
    public void put( Reputation reputation ) throws SierraException {

        assert( reputation.getSignatureValue(), "All reputations must be signed." );
        
        SignatureValue sv = reputation.getSignatureValue();

        store.put( sv.toString(), reputation );

        System.out.println( " FIXME: (debug): PUTTING in QUERY MANAGER " );
        
        //notify the QueryManager and all necessary QueryEngines
        getQueryManager().putReputation( reputation );
        
    }

    /**
     * @see Store
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: SimpleStoreEngine.java,v 1.15 2001/08/01 17:19:47 burton Exp $
     */
    public void populate( RCE rce ) {

        throw new RuntimeException( "Method not yet supported" );

    }

    /**
     * @see StoreEngine
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: SimpleStoreEngine.java,v 1.15 2001/08/01 17:19:47 burton Exp $
     */
    public QueryManager getQueryManager() throws SierraException {

        try {

            return (QueryManager)ComponentFactory.getInstance( SimpleQueryManager.class );

        } catch ( TalonException e ) {

            throw new SierraException( e );

        }

    }
    
    public void dump() {

        dump( System.out );
        
    }

    public void dump( PrintStream ps ) {

        ps.println( "-- dumping " + this.getTypeReference() + " -- " );
        
        Enumeration keys = store.keys();

        while ( keys.hasMoreElements() ) {

            String key = (String)keys.nextElement();
            Object value = store.get( key );

            ps.println( key + " == " + value.toString() );
            
        } 
        
        
    }
    
}
