/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $Id: StoreManager.java,v 1.3 2001/06/17 09:37:35 burton Exp $
 * $Project: http://sierra.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 *
 */

package org.openprivacy.sierra.store.talon.components;

import java.io.*;
import java.net.*;
import java.util.*;
import org.openprivacy.sierra.rce.talon.components.*;
import org.openprivacy.sierra.util.*;
import talon.*;
import talon.components.*;
import talon.util.net.*;


/**
 * Handles serving Stores to RCE components so that reputation storage is
 * separate from reputation calculation.  The StoreManager allows for each RCE
 * to have a different store based on their requirements.  When Sierra is
 * deployed the StoreManager will be configured to serve the correct Store to
 * the given RCE.
 * 
 * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
 * @version $Id: StoreManager.java,v 1.3 2001/06/17 09:37:35 burton Exp $
 */
public interface StoreManager extends Component {

    /**
     * Get a store which is appropriate for the given RCE.
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: StoreManager.java,v 1.3 2001/06/17 09:37:35 burton Exp $
     */
    public StoreEngine getStoreEngine( RCE rce ) throws SierraException;
    
}

