/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $Id: StoreEngine.java,v 1.3 2001/06/17 09:37:35 burton Exp $
 * $Project: http://sierra.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 *
 */

package org.openprivacy.sierra.store.talon.components;

import java.io.*;
import java.net.*;
import java.security.*;
import java.util.*;
import org.openprivacy.sierra.query.talon.components.*;
import org.openprivacy.sierra.rce.talon.components.*;
import org.openprivacy.sierra.reputation.talon.components.*;
import org.openprivacy.sierra.util.*;
import talon.*;
import talon.components.*;
import talon.util.net.*;

/**
 * The Store is responsible for saving Reputation objects to persistent storage.  
 * 
 * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
 * @version $Id: StoreEngine.java,v 1.3 2001/06/17 09:37:35 burton Exp $
 */
public interface StoreEngine extends Component {

    /**
     * Get a reputation from this Store via its URI ( reputation://[SERVER]/key/signature )
     * 
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: StoreEngine.java,v 1.3 2001/06/17 09:37:35 burton Exp $
     */
    public Reputation get( URI url ) throws SierraException;

    /**
     * Given a PublicKey and a signature for an object, return its
     * representation from disk.  
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: StoreEngine.java,v 1.3 2001/06/17 09:37:35 burton Exp $
     */
    public Reputation get( SignatureValue sv ) throws SierraException;
    
    /**
     * 
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: StoreEngine.java,v 1.3 2001/06/17 09:37:35 burton Exp $
     */
    public void put( Reputation reputation ) throws SierraException;

    /**
     * When Sierra boots up it is important to seed it with appropriate
     * Reputations.  
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: StoreEngine.java,v 1.3 2001/06/17 09:37:35 burton Exp $
     */
    public void populate( RCE rce ) throws SierraException;


    /**
     * Get the prefered QueryManager for this StoreEngine.  This allows
     * StoreEngine implementations to pick the compoent that best represents
     * their internal architecture.  
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: StoreEngine.java,v 1.3 2001/06/17 09:37:35 burton Exp $
     */
    public QueryManager getQueryManager() throws SierraException;
    
}
