/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $Id: SimpleReputation.java,v 1.14 2001/06/17 09:37:34 burton Exp $
 * $Project: http://sierra.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 *
 */

package org.openprivacy.sierra.reputation.talon.implementations;

import java.io.*;
import java.net.*;
import java.security.*;
import java.util.*;
import org.openprivacy.sierra.nym.talon.components.*;
import org.openprivacy.sierra.reputation.talon.components.*;
import org.openprivacy.sierra.util.*;
import talon.*;
import talon.components.*;
import talon.implementations.SimplePropertyManager;
import talon.util.*;
import talon.util.net.*;

/**
 * Simple implementation of a Reputation
 *
 * @see Reputation
 * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
 * @version $Id: SimpleReputation.java,v 1.14 2001/06/17 09:37:34 burton Exp $
 */
public class SimpleReputation extends BaseComponent implements Component, Reputation {

    private Reference reference = null;
    private Hashtable payloads = new Hashtable();
    private PropertyManager pm = new SimplePropertyManager();

    private Nym nym;
    private SignatureValue sv = null;
    private URI uri = null;
    
    public void init() throws TalonException {
        //add init code here
    }

    /**
     * @see Reputation
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: SimpleReputation.java,v 1.14 2001/06/17 09:37:34 burton Exp $
     */
    public Reference getReference() {

        return this.reference;

    }
    
    /**
     * @see Reputation
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: SimpleReputation.java,v 1.14 2001/06/17 09:37:34 burton Exp $
     */
    public void setReference( Reference reference ) {

        this.reference = reference;

    }
    
    /**
     * @see Reputation
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: SimpleReputation.java,v 1.14 2001/06/17 09:37:34 burton Exp $
     */
    public void setReference( URI uri ) {


        //generally speaking this should never throw an Exception
        try {
        
            Reference reference = ( Reference )ComponentFactory
                .getInstance( SimpleReference.class );
            
            reference.setURI( uri );
            
            this.setReference( reference );

        } catch (Throwable t) {

            getLogger().error( t );
            
        }
        
    }

    /**
     * @see Reputation
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: SimpleReputation.java,v 1.14 2001/06/17 09:37:34 burton Exp $
     */
    public void setReference( String uri ) {
        this.setReference( new URI( uri ) );
    }
    
    /**
     * @see Reputation
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: SimpleReputation.java,v 1.14 2001/06/17 09:37:34 burton Exp $
     */
    public Nym getNym() {

        return this.nym;

    }
    
    /**
     * @see Reputation
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: SimpleReputation.java,v 1.14 2001/06/17 09:37:34 burton Exp $
     */
    public void setNym( Nym nym ) {

        this.nym = nym;

    }
    
    /**
     * @see Reputation
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: SimpleReputation.java,v 1.14 2001/06/17 09:37:34 burton Exp $
     */
    public Enumeration getPayloads() {

        return this.payloads.elements();

    }
    
    /**
     * @see Reputation
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: SimpleReputation.java,v 1.14 2001/06/17 09:37:34 burton Exp $
     */
    public void addPayload( Payload payload ) {

        this.payloads.put( payload.getIdentifier(), payload );

    }
    
    /**
     * @see Reputation
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: SimpleReputation.java,v 1.14 2001/06/17 09:37:34 burton Exp $
     */
    public void removePayload( Payload payload ) {

        this.payloads.remove( payload.getIdentifier() );

    }

    /**
     * @see Reputation
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: SimpleReputation.java,v 1.14 2001/06/17 09:37:34 burton Exp $
     */
    public Payload getPayload( URI identifier ) {

        return (Payload)this.payloads.get( identifier );
        
    }
    
    /**
     * @see Reputation
     * @version $Id: SimpleReputation.java,v 1.14 2001/06/17 09:37:34 burton Exp $
     */
    public SignatureValue getSignatureValue() {

        return this.sv;

    }

    /**
     * @see Reputation
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: SimpleReputation.java,v 1.14 2001/06/17 09:37:34 burton Exp $
     */
    public void setSignatureValue( SignatureValue sv ) {

        this.sv = sv;

    }
    
    /**
     * @see Reputation
     * @version $Id: SimpleReputation.java,v 1.14 2001/06/17 09:37:34 burton Exp $
     */
    public URI getURI() {

        return this.uri;

    }

    /**
     * @see Reputation
     * @version $Id: SimpleReputation.java,v 1.14 2001/06/17 09:37:34 burton Exp $
     */
    public void setURI( URI uri ) {

        this.uri = uri;

    }
    
    
    /**
     * @see Reputation
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: SimpleReputation.java,v 1.14 2001/06/17 09:37:34 burton Exp $
     */
    public PropertyManager getPropertyManager() {

        return this.pm;

    }

    /**
     * @see Canonicalizable
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: SimpleReputation.java,v 1.14 2001/06/17 09:37:34 burton Exp $
     */
    public byte[] getCanonicalFormat() {

        Enumeration payloads = this.getPayloads();

        StringBuffer buff = new StringBuffer();

        if ( getURI() != null ) {

            buff.append( getURI().toString() );
            
        } 

        buff.append( getNym().getCanonicalFormat() );

        buff.append( getReference().toString() );
        
        while ( payloads.hasMoreElements() ) {

            Payload payload = (Payload)payloads.nextElement();
            
            buff.append( payload.getCanonicalFormat() );
            
        } 
        
        return buff.toString().getBytes();        
    }
    
}
    



    
