/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $Id: PropertyManagerPayload.java,v 1.9 2001/06/17 09:37:34 burton Exp $
 * $Project: http://sierra.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 *
 */

package org.openprivacy.sierra.reputation.talon.implementations;

import java.io.*;
import java.net.*;
import java.util.*;
import org.openprivacy.sierra.reputation.talon.components.*;
import org.openprivacy.sierra.util.*;
import talon.*;
import talon.components.*;
import talon.util.*;
import talon.util.net.*;

/**
 * <p>
 * A simple payload for keeping track of properties.  Properties are stored in
 * name/value/type within the PropertyManager and namespaced via the URI
 * 'identifier'. 
 *
 * <p>
 * Applications that which to gain reputation should use a known identifier so
 * that other applications can analyze their data.
 *
 * <p>Sierra defines some default identifiers/namespaces that can be reused:
 *
 * <code>openprivacy:///properties</code>
 * <ul>
 *   <li><code>openprivacy:///properties/time-created</code>: Used to time stamp
 *       all Reputation objects.</li>
 * </li>
 *
 * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
 * @version $Id: PropertyManagerPayload.java,v 1.9 2001/06/17 09:37:34 burton Exp $
 */
public class PropertyManagerPayload extends BasePropertyManager implements Payload,
                                                                           PropertyManager,
                                                                           Canonicalizable {

    private URI identifier = null;

    public void init() {

        this.setIdentifier( this.getTypeReference() );

    }

    /**
     * @see Payload
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: PropertyManagerPayload.java,v 1.9 2001/06/17 09:37:34 burton Exp $
     */
    public void setIdentifier( URI identifier ) { 

        this.identifier = identifier;

    }

    /**
     * @see Payload
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: PropertyManagerPayload.java,v 1.9 2001/06/17 09:37:34 burton Exp $
     */
    public URI getIdentifier() { 

        return this.identifier;

    }

    /**
     * @see Canonicalizable
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: PropertyManagerPayload.java,v 1.9 2001/06/17 09:37:34 burton Exp $
     */
    public byte[] getCanonicalFormat() {

        Enumeration keys = this.getKeys();

        StringBuffer buff = new StringBuffer();

        buff.append( getIdentifier().toString() );
        
        while ( keys.hasMoreElements() ) {

            String name = (String)keys.nextElement();
            Object value = getProperty( name );

            buff.append( name );
            buff.append( "=" );
            buff.append( value );
            
        } 
        
        return buff.toString().getBytes();        
    }
    
}
