/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $Id: OverallMarkupPayload.java,v 1.6 2001/07/04 08:48:50 burton Exp $
 * $Project: http://sierra.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 *
 */

package org.openprivacy.sierra.reputation.talon.implementations;

import java.io.*;
import java.net.*;
import java.util.*;

import org.openprivacy.sierra.nym.talon.components.*;
import org.openprivacy.sierra.query.talon.components.*;
import org.openprivacy.sierra.query.talon.implementations.*;
import org.openprivacy.sierra.rce.talon.components.*;
import org.openprivacy.sierra.reputation.talon.components.*;
import org.openprivacy.sierra.util.*;

import talon.*;
import talon.components.*;
import talon.util.net.*;

/**
 * Supports the representation of an overall opinion for a resource.  We realize
 * that there may be a more fine grained approach but this is simple.
 *
 * @see <a href"http://www.openprivacy.org">http://www.openprivacy.org</a>
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: OverallMarkupPayload.java,v 1.6 2001/07/04 08:48:50 burton Exp $
 */
public class OverallMarkupPayload extends BaseComponent implements Payload {

    public static final float OPTION_UNRATED = -1;

    public static final float OPTION_TERRIBLE = 0;

    public static final float OPTION_BAD = 1;

    public static final float OPTION_AVERAGE = 2;

    public static final float OPTION_GOOD = 3;

    public static final float OPTION_EXCELLENT = 4;

    public static final URI IDENTIFIER
        = new URI( "http://schemas.openprivacy.org/reputation/markup/overall" );
    
    private URI identifier;

    private float option = OPTION_UNRATED;
    
    /**
     * @see Component#init
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: OverallMarkupPayload.java,v 1.6 2001/07/04 08:48:50 burton Exp $
     */
    public void init() {

        this.setIdentifier( IDENTIFIER );
        
    } 

    /**
     * 
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: OverallMarkupPayload.java,v 1.6 2001/07/04 08:48:50 burton Exp $
     */
    public URI getIdentifier() {

        return this.identifier;

    }

    /**
     * Set the identifier.
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: OverallMarkupPayload.java,v 1.6 2001/07/04 08:48:50 burton Exp $
     */
    public void setIdentifier( URI identifier ) {

        this.identifier = identifier;        
        
    }

    /**
     * This is a really easy implementation.  Just basically the value of the
     * option. 
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     * @version $Id: OverallMarkupPayload.java,v 1.6 2001/07/04 08:48:50 burton Exp $
     */
    public byte[] getCanonicalFormat() {
        
        return Float.toString( this.getOption() ).getBytes();
        
    }


    /**
     * Get the option tha thte user has choosen.  
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: OverallMarkupPayload.java,v 1.6 2001/07/04 08:48:50 burton Exp $
     */
    public float getOption() {

        return this.option;

    }
    
    
    /**
     * 
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: OverallMarkupPayload.java,v 1.6 2001/07/04 08:48:50 burton Exp $
     */
    public void setOption( float option ) { 

        this.option = option;

    }

    /**
     * Get a string representation of this Payload.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: OverallMarkupPayload.java,v 1.6 2001/07/04 08:48:50 burton Exp $
     */
    public String toString() {

        //we need to round this down to the nearest integer point.  
        int value = (int)this.getOption();

        String human = "";
        
        switch ( value ) {

            case (int)OPTION_UNRATED:
                human = "Unrated";
                break;
                
            case (int)OPTION_TERRIBLE:
                human = "Terrible";
                break;
                
            case (int)OPTION_BAD:
                human = "Bad";
                break;
                
            case (int)OPTION_AVERAGE:
                human = "Average";
                break;
                
            case (int)OPTION_GOOD:
                human = "Good";
                break;
                
            case (int)OPTION_EXCELLENT:
                human = "Excellent";
                break;
                
            default:
                human = "Unknown";

        }

        return human + " ( " + this.getOption() + " )";
        
    }
    
} 

