/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $Id: Reputation.java,v 1.7 2001/06/17 09:37:34 burton Exp $
 * $Project: http://sierra.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 *
 */

package org.openprivacy.sierra.reputation.talon.components;

import java.io.*;
import java.net.*;
import java.security.*;
import java.util.*;
import org.openprivacy.sierra.nym.talon.components.*;
import org.openprivacy.sierra.util.*;
import talon.*;
import talon.components.*;
import talon.util.net.*;

/**
 * <p> Contains all information for a Reputation request.  This is an interface
 * for an object which is the central piece of data within the Sierra Reputation
 * Management System.
 *
 * <p> Certain information is required for every Reputation object.
 *
 * <ul>
 *   <li><b>Reference: </b>Must point to some object in URI space.</li>
 *
 * </ul>
 *
 * @see http://www.openprivacy.org/reputations for more info on reputations. 
 * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
 * @version $Id: Reputation.java,v 1.7 2001/06/17 09:37:34 burton Exp $
 */
public interface Reputation extends Component, Canonicalizable {

    /**
     * Return the reference for this Reputation.  This will usually be a URI. 
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: Reputation.java,v 1.7 2001/06/17 09:37:34 burton Exp $
     */
    public Reference getReference();
     
    /**
     * @see setReference
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: Reputation.java,v 1.7 2001/06/17 09:37:34 burton Exp $
     */
    public void setReference( Reference reference );
    
    /**
     * @see setReference
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: Reputation.java,v 1.7 2001/06/17 09:37:34 burton Exp $
     */
    public void setReference( URI uri );

    /**
     * @see setReference
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: Reputation.java,v 1.7 2001/06/17 09:37:34 burton Exp $
     */
    public void setReference( String uri );

    
    /**
     * @see Nym
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: Reputation.java,v 1.7 2001/06/17 09:37:34 burton Exp $
     */
    public Nym getNym();
 
    /**
     * @see Nym
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: Reputation.java,v 1.7 2001/06/17 09:37:34 burton Exp $
     */
    public void setNym( Nym nym );
 

    /**
     * @see Payload
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: Reputation.java,v 1.7 2001/06/17 09:37:34 burton Exp $
     */
    public Enumeration getPayloads();
 
    /**
     * @see Payload
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: Reputation.java,v 1.7 2001/06/17 09:37:34 burton Exp $
     */
    public void addPayload( Payload payload );

    /**
     * @see Payload
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: Reputation.java,v 1.7 2001/06/17 09:37:34 burton Exp $
     */
    public void removePayload( Payload payload );

    /**
     * Get a payload based on it's URI.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: Reputation.java,v 1.7 2001/06/17 09:37:34 burton Exp $
     */
    public Payload getPayload( URI identifier );
    
    /**
     * <p>
     * Return a unique, possibly verifiable, hash for this Reputation.
     *
     * <p> Depending on the principal, this will return a Hash value for this
     * object.  In most real world situations, this will be computed from the
     * private key of the principal.  If based on a private/public key pair this
     * must be computed before it is sent to a Reputation Server because an RS
     * can't compute it without the private key.
     *
     * <p>
     * There are numerous methods of generating a hash:
     *
     * <ul>
     *     <li>From a private key and validated by a public key.
     *     <li>MD5 version of the raw data.  The server has no way to validate
     *         the intgrity of the message with this option.
     *     <li>If done with a Java Virtual Machine.. a hashCode().  Note that
     *         this method is not secure but should work in debug environments (where it
     *         should remain).
     * <ul>
     *
     * <p>
     * Note that if this object is modified it's SignatureValue needs to be
     * updated.  It is important that this is updated everytime you pass it
     * around within the system.  Your local application can modify a Reputation
     * object as much as it wants but if it wants to pass this to another
     * application running as another Nym or possibly another server it needs to
     * update the signature value. 
     * 
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: Reputation.java,v 1.7 2001/06/17 09:37:34 burton Exp $
     */
    public SignatureValue getSignatureValue();


    /**
     * @see #getSignatureValue
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: Reputation.java,v 1.7 2001/06/17 09:37:34 burton Exp $
     */
    public void setSignatureValue( SignatureValue sv );
    
    /**
     * <p>Get the URI for this Reputation.  Should be:
     * 
     *  <code>reputation://[SERVER]/PRINCIPAL/HASH</code>
     *
     * <p>
     * SERVER is optional.
     *
     * <p> The PRINCIPAL and HASH information needs to be ascii armored.
     * 
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: Reputation.java,v 1.7 2001/06/17 09:37:34 burton Exp $
     */
    public URI getURI();

    /**
     * @see #getURI
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: Reputation.java,v 1.7 2001/06/17 09:37:34 burton Exp $
     */
    public void setURI( URI uri );
    
}


