/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $Id: Payload.java,v 1.6 2001/06/17 09:37:34 burton Exp $
 * $Project: http://sierra.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 *
 */

package org.openprivacy.sierra.reputation.talon.components;

import java.util.*;
import talon.*;
import talon.util.net.*;

import org.openprivacy.sierra.util.*;

/**
 * 
 *
 * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
 * @version $Id: Payload.java,v 1.6 2001/06/17 09:37:34 burton Exp $
 */
public interface Payload extends Component, Canonicalizable {

    /**
     * Get the current identifier for this payload.  This is just a URI that
     * uniquely identifies this type of payload.  This does not have to be
     * specified but has been added to the Payload component so that all
     * Payloads have support for 
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: Payload.java,v 1.6 2001/06/17 09:37:34 burton Exp $
     */
    public URI getIdentifier();

    /**
     * Set the identifier.
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: Payload.java,v 1.6 2001/06/17 09:37:34 burton Exp $
     */
    public void setIdentifier( URI identifier );
     
}
