/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $Id: ReputationConstrainer.java,v 1.10 2001/06/17 09:37:33 burton Exp $
 * $Project: http://sierra.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 *
 */

package org.openprivacy.sierra.reputation;

import java.io.*;
import java.net.*;
import java.util.*;
import org.openprivacy.sierra.nym.talon.components.*;
import org.openprivacy.sierra.reputation.talon.implementations.*;
import org.openprivacy.sierra.reputation.talon.components.*;
import org.openprivacy.sierra.util.*;
import talon.*;
import talon.components.*;
import talon.util.*;
import talon.util.net.*;

/**
 * Before a Reputation can be used within the system as a whole (interact with
 * other Nyms, be transported across networks), certain operations should be
 * performed, signatures should be updated, correct URIs should be updated, etc.
 * Note that some of this information should not be relied on.  Reputation
 * Systems reputation system should be mutually suspicious of each other.  The
 * ReputationConstrianer is used somewhat internally and so that we are at least
 * polite to other systems (there is no sense in having invalid signatures, etc
 * as these may just be ignored). 
 *
 * @see Reputation
 * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
 * @version $Id: ReputationConstrainer.java,v 1.10 2001/06/17 09:37:33 burton Exp $
 */
public class ReputationConstrainer {

    public static void constrain( Reputation reputation, NymBuilder nb )
        throws SierraException {

        if ( reputation.getReference() == null ) {
            throw new SierraException( "Given reputation must contain a reference pointer." );
        } 
        
        //update the objects Nym
        reputation.setNym( nb.getNym() );

        //add a payload with the timestamp...

        try { 

            PropertyManagerPayload pmp = (PropertyManagerPayload)ComponentFactory
                .getInstance( PropertyManagerPayload.class );
            
            pmp.setLong( "openprivacy:///reserved-properties/time-created", System.currentTimeMillis() );
        
            reputation.addPayload( pmp );

        } catch ( TalonException e ) {
            throw new SierraException( e );
        }
        
        //update the objects signature

        //WARNING: This should be the last modification to the object (unless
        //you constrain it again).   Any modification will cause it to fail
        //signature validation
        reputation.setSignatureValue( SignatureValueCalculator.getSignatureValue( reputation, nb ) );

        //update the objects URI... this is outside of the signature space.
        reputation.setURI( ReputationURIEncoder.encode( reputation ) );
        
    }

}
