/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $Id: ReputationReferenceMap.java,v 1.3 2001/06/17 09:37:33 burton Exp $
 * $Project: http://sierra.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 *
 */

package org.openprivacy.sierra.rce.talon.implementations.util;



import java.io.*;
import java.net.*;
import java.util.*;
import org.openprivacy.sierra.nym.talon.components.*;
import org.openprivacy.sierra.rce.talon.components.*;
import org.openprivacy.sierra.reputation.talon.components.*;
import org.openprivacy.sierra.util.*;
import talon.*;
import talon.components.*;
import talon.implementations.*;
import talon.util.net.*;

/**
 * Internally stores a mechanism to map references (URIs) to lists of Reputations. 
 *
 * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
 * @version $Id: ReputationReferenceMap.java,v 1.3 2001/06/17 09:37:33 burton Exp $
 */
public class ReputationReferenceMap {

    private SimplePropertyManager references = new SimplePropertyManager();
    
    public void putReputation( Reputation reputation ) {

        getVector( reputation.getReference() ).addElement( reputation );
        
    }

    /**
     * Get a set of Reptutations via Reference.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ReputationReferenceMap.java,v 1.3 2001/06/17 09:37:33 burton Exp $
     */
    public Reputation[] getReputations( Reference reference ) {

        Vector v = getVector( reference );

        Reputation[] reps = new Reputation[ v.size() ];
        v.copyInto( reps );
        return reps;
        
    }


    /**
     * Get a Vector of reputations from the references has or return a new one. 
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: ReputationReferenceMap.java,v 1.3 2001/06/17 09:37:33 burton Exp $
     */
    private Vector getVector( Reference reference ) {

        Vector v = (Vector)references.getProperty( reference.getURI().toString() );

        if ( v == null ) {
            v = new Vector();

            references.setProperty( reference.getURI().toString(), v );
        } 
        
        return v;
    }
    
}
