/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $Id: WeightedRCE.java,v 1.10 2001/07/03 07:55:19 burton Exp $
 * $Project: http://sierra.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 *
 */

package org.openprivacy.sierra.rce.talon.implementations;

import java.io.*;
import java.net.*;
import java.util.*;

import org.openprivacy.sierra.factories.*;
import org.openprivacy.sierra.query.talon.components.*;
import org.openprivacy.sierra.query.talon.implementations.*;
import org.openprivacy.sierra.nym.talon.components.*;
import org.openprivacy.sierra.rce.talon.components.*;
import org.openprivacy.sierra.rce.talon.implementations.util.*;
import org.openprivacy.sierra.reputation.*;
import org.openprivacy.sierra.reputation.talon.components.*;
import org.openprivacy.sierra.reputation.talon.implementations.*;
import org.openprivacy.sierra.util.*;

import talon.*;
import talon.components.*;
import talon.util.net.*;

/**
 * Calculates the Mean of all placed reputations of a given URI and applies
 * weights associated with the URI which have been configured by the user.
 *
 * @see http://www.openprivacy.org
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: WeightedRCE.java,v 1.10 2001/07/03 07:55:19 burton Exp $
 */
public class WeightedRCE extends BaseRCE implements RCE {


    //instance veriables
    ReputationReferenceMap map = new ReputationReferenceMap();

    private Nym nym = null;

    private Logger logger = null;
    
    /**
     * @see Component
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: WeightedRCE.java,v 1.10 2001/07/03 07:55:19 burton Exp $
     */
    public void init() {

        this.logger = getLogger();
        
        //FIXME: on init i need to go through every known reputation and do a
        //putReputation on it.
        

    } 

    /**
     * @see RCE#putReputation
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: WeightedRCE.java,v 1.10 2001/07/03 07:55:19 burton Exp $
     */
    public Reputation getReputation( RCEQuery query ) throws SierraException,
                                                             ReputationNotFoundException {

        if ( query instanceof ReferenceRCEQuery ) {

            Reference reference = ((ReferenceRCEQuery)query).getReference();
            
            Reputation[] reps = map.getReputations( reference );

            float total = 0;

            //go through each reputation...
            for ( int i = 0; i < reps.length; ++i ) {

                OverallMarkupPayload omp = (OverallMarkupPayload)reps[i].getPayload( OverallMarkupPayload.IDENTIFIER );

                total = total + omp.getOption();
                
            } 

            float computed = 0;

            //make sure not to divide by 0
            if ( reps.length != 0 ) {
                computed = total / reps.length;    
            } else {
                computed = OverallMarkupPayload.OPTION_UNRATED;
            }
            
            
            //FIXME: need to go over all reputations, analyse payloads and then
            //average them out.
            
            //build the reputation I want to return.
            Reputation rep = ReputationFactory.getInstance();

            rep.setReference( reference );
            
            rep.setNym( this.getNym() );

            //now we need to add the payload.

            try {

                OverallMarkupPayload omp = (OverallMarkupPayload)ComponentFactory
                    .getInstance( OverallMarkupPayload.class );

                omp.setOption( computed );
                
                rep.addPayload( omp );
                
            } catch ( TalonException te ) {
                throw new SierraException( te );
            }
            
            
            //FIXME: we can't constrain right now.  This depends on the following bug:
            // http://bugzilla.openprivacy.org/show_bug.cgi?id=47
            //ReputationConstrainer.constrain( rep, getNym() ); 
            
            return rep;
            
        } else {

            throw new SierraException( "Query type not supported: " + query.getTypeReference().toString() );
                
        }
        
    }

    
    /**
     * @see RCE#putReputation
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: WeightedRCE.java,v 1.10 2001/07/03 07:55:19 burton Exp $
     */
    public Reputation getReputation( Reference reference ) throws SierraException,
                                                                  ReputationNotFoundException {

        try {

            ReferenceRCEQuery query = (ReferenceRCEQuery)ComponentFactory
                .getInstance( ReferenceRCEQuery.class );


            query.setReference( reference );

            return getReputation( query );
            
        } catch ( TalonException e ) {
            throw new SierraException( e );
        }
        
    }

    
    /**
     * @see RCE#putReputation
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: WeightedRCE.java,v 1.10 2001/07/03 07:55:19 burton Exp $
     */
    public void putReputation( Reputation reputation ) throws SierraException  {

        logger.debug( "Putting reputation in store engine: " + reputation.toString() );
        
        this.getStoreEngine().put( reputation );
        
        map.putReputation( reputation );
    }
    
    /**
     * @see RCE#getNym
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: WeightedRCE.java,v 1.10 2001/07/03 07:55:19 burton Exp $
     */
    public Nym getNym() {
        return this.nym;
    }
    
} 

