/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $Id: MeanRCE.java,v 1.10 2001/07/03 07:55:19 burton Exp $
 * $Project: http://sierra.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 *
 */

package org.openprivacy.sierra.rce.talon.implementations;

import java.util.*;
import org.openprivacy.sierra.nym.talon.components.*;
import org.openprivacy.sierra.query.talon.components.*;
import org.openprivacy.sierra.query.talon.implementations.*;
import org.openprivacy.sierra.rce.talon.components.*;
import org.openprivacy.sierra.reputation.talon.components.*;
import org.openprivacy.sierra.util.*;
import talon.*;
import talon.util.net.*;

/**
 * Calculates the Mean of all placed reputations of a given URI.
 *
 * @see http://www.openprivacy.org
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: MeanRCE.java,v 1.10 2001/07/03 07:55:19 burton Exp $
 */
public class MeanRCE extends BaseRCE implements RCE {


    ReputationNymMap map = new ReputationNymMap();

    private Nym nym = null;
    
    /**
     * @see Component
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: MeanRCE.java,v 1.10 2001/07/03 07:55:19 burton Exp $
     */
    public void init() { } 

    /**
     * @see RCE#putReputation
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: MeanRCE.java,v 1.10 2001/07/03 07:55:19 burton Exp $
     */
    public Reputation getReputation( RCEQuery query ) throws SierraException,
                                                             ReputationNotFoundException {

        if ( query instanceof ReferenceRCEQuery ) {

            Reference reference = ((ReferenceRCEQuery)query).getReference();
            
            Reputation[] reps = map.getReputations( reference );
            
            //FIXME: should NOT return null!  
            return null;
            
        } else {

            throw new SierraException( query.getTypeReference().toString() );
                
        }
        
    }

    
    /**
     * @see RCE#putReputation
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: MeanRCE.java,v 1.10 2001/07/03 07:55:19 burton Exp $
     */
    public Reputation getReputation( Reference reference ) throws SierraException,
                                                                  ReputationNotFoundException {

        try {

            ReferenceRCEQuery query = (ReferenceRCEQuery)ComponentFactory
                .getInstance( ReferenceRCEQuery.class );


            query.setReference( reference );

            return getReputation( query );
            
        } catch ( TalonException e ) {
            throw new SierraException( e );
        }
        
    }

    
    /**
     * @see RCE#putReputation
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: MeanRCE.java,v 1.10 2001/07/03 07:55:19 burton Exp $
     */
    public void putReputation( Reputation reputation ) {
        map.putReputation( reputation );
    }


    
    /**
     * @see RCE#getNym
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: MeanRCE.java,v 1.10 2001/07/03 07:55:19 burton Exp $
     */
    public Nym getNym() {
        return this.nym;
    }
    
} 

/**
 * Internally stores a mechanism to map references (URIs) to lists of Reputations. 
 *
 * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
 * @version $Id: MeanRCE.java,v 1.10 2001/07/03 07:55:19 burton Exp $
 */
class ReputationNymMap {

    private Hashtable references = new Hashtable();
    
    public void putReputation( Reputation reputation ) {

        getVector( reputation.getReference() ).addElement( reputation );
        
    }

    public Reputation[] getReputations( Reference reference ) {

        Vector v = getVector( reference );

        Reputation[] reps = new Reputation[ v.size() ];
        v.copyInto( reps );
        return reps;
        
    }


    /**
     * Get a Vector of reputations from the references has or return a new one. 
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: MeanRCE.java,v 1.10 2001/07/03 07:55:19 burton Exp $
     */
    private Vector getVector( Reference reference ) {

        Vector v = (Vector)references.get( reference );

        if ( v == null ) {
            v = new Vector();

            references.put( reference, v );
        } 
        
        return v;
    }
    
}
