/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $Id: BaseRCE.java,v 1.8 2001/06/17 09:37:32 burton Exp $
 * $Project: http://sierra.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 *
 */

package org.openprivacy.sierra.rce.talon.implementations;

//talon stuff
import talon.*;
import talon.util.net.*;

//sierra stuff
import org.openprivacy.sierra.query.*;
import org.openprivacy.sierra.query.talon.components.*;
import org.openprivacy.sierra.rce.talon.components.*;
import org.openprivacy.sierra.store.talon.components.*;
import org.openprivacy.sierra.*;
import org.openprivacy.sierra.util.*;


/**
 * Calculates the Mean of all placed reputations of a given URI.
 *
 * @see http://www.openprivacy.org
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: BaseRCE.java,v 1.8 2001/06/17 09:37:32 burton Exp $
 */
public abstract class BaseRCE extends BaseComponent implements RCE {

    /**
     * @see RCE
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: BaseRCE.java,v 1.8 2001/06/17 09:37:32 burton Exp $
     */
    public QueryEngine getQueryEngine() throws SierraException {
        throw new QueryNotSupportedException( "This RCE does not define a QueryEngine." );
    }


    /**
     * @see RCE
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: BaseRCE.java,v 1.8 2001/06/17 09:37:32 burton Exp $
     */
    public StoreEngine getStoreEngine() throws SierraException {

        try {

            ComponentHandle handle = HandleManager
                .byName( "talon:///component-name/product/sierra/name/store_engine" );

            return (StoreEngine)ComponentFactory.getInstance( handle );

        } catch ( TalonException te ) {

            throw new SierraException( te );

        }

    }
    
}

