/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $Id: RCEContext.java,v 1.3 2001/06/17 09:37:32 burton Exp $
 * $Project: http://sierra.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 *
 */

package org.openprivacy.sierra.rce.talon.components;


import java.io.*;
import java.net.*;
import java.util.*;
import org.openprivacy.sierra.util.*;
import talon.*;
import talon.components.*;
import talon.util.net.*;

/**
 * Represents a class which abstract runtime information about a Reputation
 * request.  This could include target RCE, bias, etc.  Basically
 * anything that needs to be passed to an RCE at runtime.
 *
 * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
 * @version $Id: RCEContext.java,v 1.3 2001/06/17 09:37:32 burton Exp $
 */
public interface RCEContext extends Component {


    /**
     * <p>
     * Specify the target RCE for this request.  This may be specific to a
     * Sierra implementation.  If the target is unknown you might get an
     * Exception from your RCE.  
     *
     * <p>
     * <code>talon://</code> URIs should be supported so that you can target a specific
     * component instance of an RCE.
     *
     * <p>
     * Example: <code>talon://universe/component/org.openprivacy.sierra.rce.talon.implementations.MeanRCE/hashcode/9872365</code>
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: RCEContext.java,v 1.3 2001/06/17 09:37:32 burton Exp $
     */
    public URI getTargetRCE();

    /**
     * @see #getTargetRCE
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: RCEContext.java,v 1.3 2001/06/17 09:37:32 burton Exp $
     */
    public void setTargetRCE( URI targetRCE );
    
}
