/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $Id: RCE.java,v 1.6 2001/06/17 09:37:32 burton Exp $
 * $Project: http://sierra.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 *
 */

package org.openprivacy.sierra.rce.talon.components;

//java stuff.
import java.io.*;
import java.net.*;
import java.util.*;

//sierra support 
import org.openprivacy.sierra.nym.talon.components.*;
import org.openprivacy.sierra.query.talon.components.*;
import org.openprivacy.sierra.reputation.talon.components.*;
import org.openprivacy.sierra.store.talon.components.*;
import org.openprivacy.sierra.util.*;

//talon support 
import talon.*;
import talon.components.*;
import talon.util.net.*;

/**
 * <p> Abstraction of a Reputation Calculation Engine (RCE).  This is basically
 * a mechanism to abstract the calcluation of a Reputation.  Reputations
 * (opinions) can be added to an RCE and then the RCE can provide some mechanism
 * to respond with for getReputation.
 *
 * <p> Generally an RCE just provides the calculation of an aggregated set of
 * Reputations.  For persistence and performance reasons an RCE should use a
 * Store component to handle its own persistence.  The RCE should use a
 * StoreManager so that Sierra can be deployed with the correct RCE -> Store
 * mapping.
 *
 * @see http://www.openprivacy.org
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: RCE.java,v 1.6 2001/06/17 09:37:32 burton Exp $
 */
public interface RCE extends Component {

    /**
     * Similer to getReptuation( Reference ) except that advanced query info can
     * specified.  There ReferenceRCEQuery should always be supported. 
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: RCE.java,v 1.6 2001/06/17 09:37:32 burton Exp $
     */
    public Reputation getReputation( RCEQuery query ) throws SierraException;

    /**
     * <p>
     * Given a Reference obtain a Reputation object which contains additional
     * information.  This would usually be a payload with additional data.
     *
     * <p>
     * The Reference is used as a pointer to information which should be used to
     * obtain aggregate reputation objects.
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: RCE.java,v 1.6 2001/06/17 09:37:32 burton Exp $
     */
    public Reputation getReputation( Reference reference ) throws SierraException;
    

    /**
     * Add a reputation to this RCE.  If the RCE does not directly support this
     * Reputation it is a good idea to throw and Exception.  A good example of
     * this is when a Reputation is added to this RCE but it doesn't have a
     * stable/fast mechansim to index this content.  If additional Talon
     * sub-components are used to index/manage Reputation object their
     * reputation can be used to determine if they are supported.  
     * 
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: RCE.java,v 1.6 2001/06/17 09:37:32 burton Exp $
     */
    public void putReputation( Reputation reputation ) throws SierraException;
    
    /**
     * Determine the Nym under which this RCE is running.
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: RCE.java,v 1.6 2001/06/17 09:37:32 burton Exp $
     */
    public Nym getNym() throws SierraException;

    /**
     * Return the QueryEngine used by this RCE.  An application can execute data
     * queries on this RCE by obtaining its default QueryEngine.
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: RCE.java,v 1.6 2001/06/17 09:37:32 burton Exp $
     */
    public QueryEngine getQueryEngine() throws SierraException;

    /**
     * Return the StoreEngine used by this RCE.  
     *
     * @deprecated Does another object really need the Store that this RCE is using???
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: RCE.java,v 1.6 2001/06/17 09:37:32 burton Exp $
     */
    public StoreEngine getStoreEngine() throws SierraException;
    
} 

