/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $Id: SelectReputation.java,v 1.5 2001/06/17 09:37:32 burton Exp $
 * $Project: http://sierra.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 *
 */

package org.openprivacy.sierra.query.talon.implementations.simple.util;

import java.io.*;
import java.net.*;
import java.util.*;
import java.sql.*;
import org.openprivacy.sierra.query.talon.components.*;
import org.openprivacy.sierra.query.talon.implementations.*;
import org.openprivacy.sierra.query.talon.implementations.simple.*;
import org.openprivacy.sierra.reputation.talon.components.*;
import org.openprivacy.sierra.reputation.talon.implementations.*;
import org.openprivacy.sierra.util.*;
import org.openprivacy.sierra.util.sql.*;
import talon.*;
import talon.components.*;
import talon.util.net.*;

/**
 * Takes care of all operations necessary to insert Reputations into the
 * database.
 * 
 * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
 * @version $Id: SelectReputation.java,v 1.5 2001/06/17 09:37:32 burton Exp $
 */
public class SelectReputation {

    private DatabaseConnectionPool dcp = null;
    private PropertyManager pm = null;
    private Result result = null;
    
    /**
     * FK from the properties table to the identify table.  -1 if not defined.
     */       
    int table_properties_fk_reputation = -1;
    
    public SelectReputation( DatabaseConnectionPool dcp,
                             PropertyManager pm ) {

        this.dcp = dcp;
        this.pm = pm;
        
    }
    
    /**
     * Insert this reputation.
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: SelectReputation.java,v 1.5 2001/06/17 09:37:32 burton Exp $
     */
    public void commit() throws Exception {

        //FIXME: don't use raw SQL here.. BAD!!!
      

      //  select distinct a.reputation from properties AS a,
      //                                    properties AS b where a.reputation = b.reputation and
      //                                                          a.identifier = b.identifier and
      //                                                          a.name='foo' and
      //                                                          b.name='openprivacy:///properties/time-created';
      //
      // The algorithm for this is very simple.  build the above SQL statement...
      

        StringBuffer select = new StringBuffer();
        
        select.append( "select distinct reputations.uri from ");

        //append aliased table names.
        
        for ( int i = 0; i < pm.size(); ++i ) {

            select.append( "properties AS " );
            select.append( getTableAlias( i ) );
            
            select.append( ", " );
            //if ( i < (pm.size() - 1) ) {
            //    
            //} 
            
            
        } 
        
        select.append( " reputations where a.reputation = reputations.pk and " );
        
        Enumeration keys = pm.getKeys();

        int i = 0;
        while ( keys.hasMoreElements() ) {

            //FIXME: I am adding all records as strings here.  This is a BAD
            //idea.  It is much better to add the appropriate types.
            String name = (String)keys.nextElement();
            String value = pm.getProperty( name ).toString();

            //select.addString( "name", name );
            //            select.addString( "value", value );

            String table = getTableAlias( i );

            select.append( table + ".name='" );
            select.append( name );
            select.append( "' and " + table + ".value='" );
            select.append( value );
            select.append( "'" );

            if ( keys.hasMoreElements() ) {
                select.append( " and " );
            } 
            
            
            ++i;
        }
        

        select.append( ";" );

        ResultSet resultSet;
        Statement statement;
            
        try {

            statement = dcp.getConnection().createStatement();
            resultSet = statement.executeQuery( select.toString() );
            
        } catch ( SQLException se ) {
            throw new Exception( select.toString() + " -> " + se.getMessage() );
        }

        

        dcp.getConnection().commit();

        //holds a result set of reputation:// uris we need to return.
        result = (Result)ComponentFactory.getInstance( SimpleResult.class );
        
        while ( resultSet.next() ) {

            String uri = resultSet.getString( "uri" );

            result.putReputation( new URI( uri ) );
            
        } 
        
        
        
    }

    private String getTableAlias( int i ) throws Exception {

        if ( i > 25 ) {
            throw new SierraException( "Only 26 properties are supported" );
        } 

        char[] aliases = {'a','b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k',
                          'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v',
                          'w', 'x', 'y', 'z'};

        return new Character( aliases[i] ).toString();
    }

    public Result getResult() {
        return this.result;
    }
    
}

    

