/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $Id: InsertReputation.java,v 1.9 2001/08/01 17:19:47 burton Exp $
 * $Project: http://sierra.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 *
 */

package org.openprivacy.sierra.query.talon.implementations.simple.util;

import java.io.*;
import java.net.*;
import java.util.*;
import org.openprivacy.sierra.query.talon.implementations.simple.*;
import org.openprivacy.sierra.reputation.talon.components.*;
import org.openprivacy.sierra.reputation.talon.implementations.*;
import org.openprivacy.sierra.util.*;
import org.openprivacy.sierra.util.sql.*;
import talon.*;
import talon.components.*;
import talon.util.net.*;

/**
 * Takes care of all operations necessary to insert Reputations into the
 * database.
 * 
 * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
 * @version $Id: InsertReputation.java,v 1.9 2001/08/01 17:19:47 burton Exp $
 */
public class InsertReputation {

    private DatabaseConnectionPool dcp = null;
    private Reputation reputation = null;
    private SimpleQueryEngine sqe = null;

    /**
     * FK from the properties table to the identify table.  -1 if not defined.
     */       
    int table_properties_fk_reputation = -1;
    
    public InsertReputation( DatabaseConnectionPool dcp,
                             Reputation reputation,
                             SimpleQueryEngine sqe ) {

        this.dcp = dcp;
        this.reputation = reputation;
        this.sqe = sqe;
        
    }
    
    /**
     * 
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: InsertReputation.java,v 1.9 2001/08/01 17:19:47 burton Exp $
     */
    private void insertIntoReputationsTable( DatabaseConnectionPool dcp )
        throws Exception {

        
        sqe.getLogger().message( "Adding database record for reputation: " + reputation.getURI().toString() );
        
        Insert insert = new Insert();
        insert.setDatabaseConnectionPool( dcp )
            .setTable( "reputations" )
            .addString( "reference", reputation.getReference().toString() )
            .addString( "uri", reputation.getURI().toString() );
        
        insert.commit();


        //now need to pull out the uri from teh reputations 

        Select select = new Select();
        select.setDatabaseConnectionPool( dcp )
            .setTable( "reputations" )
            .addString( "uri", reputation.getURI().toString() );

        select.commit();

        this.table_properties_fk_reputation = select.getResultSet().getInt( "pk" );
        
    }

    
    /**
     * 
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: InsertReputation.java,v 1.9 2001/08/01 17:19:47 burton Exp $
     */
    private void insertIntoIdentifiersTable( DatabaseConnectionPool dcp, Payload payload )
        throws Exception {

        Select select = new Select();
        select.setDatabaseConnectionPool( dcp )
            .setTable( "identifiers" )
            .addString( "uri", payload.getIdentifier().toString() );

        select.commit();
        
        //only insert if there are no records in the DB.
        //HACK: there is no easy way to find out if no results were found. :(
        if ( select.getResultSet().next() == false ) {

            sqe.getLogger().message( "Adding database record for identifier: " + payload.getIdentifier().toString() );
            
            Insert insert = new Insert();
            insert.setDatabaseConnectionPool( dcp )
                .setTable( "identifiers" )
                .addString( "uri", payload.getIdentifier().toString() );
        
            insert.commit();

        } 
        
    }

    /**
     * 
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: InsertReputation.java,v 1.9 2001/08/01 17:19:47 burton Exp $
     */
    private void insertIntoPropertiesTable( DatabaseConnectionPool dcp, Payload payload )
        throws Exception {

        //get the identifier id.. always compute this because it changes per payload.

        int table_properties_fk_identifier = -1;
            
        Select select_identifier = new Select();
        select_identifier.setDatabaseConnectionPool( dcp )
            .setTable( "identifiers" )
            .addString( "uri", payload.getIdentifier().toString() );

        select_identifier.commit();

        select_identifier.getResultSet().next();
        table_properties_fk_identifier = select_identifier.getResultSet().getInt( "pk" );

        
        //get the reputation id (if we already haven't figured it out)

        if ( table_properties_fk_reputation == -1 ) {
            
            Select select_reputation = new Select();
            select_reputation.setDatabaseConnectionPool( dcp )
                .setTable( "reputations" )
                .addString( "uri", payload.getIdentifier().toString() );

            select_reputation.commit();

            select_reputation.getResultSet().next();
            table_properties_fk_reputation = select_reputation.getResultSet().getInt( "pk" );

        } 
        


        //go over all properties and add them.
        PropertyManagerPayload pmp = (PropertyManagerPayload)payload;


        //add all properties

        Enumeration keys = pmp.getKeys();
            
        while ( keys.hasMoreElements() ) {

            //FIXME: I am adding all records as strings here.  This is a BAD
            //idea.  It is much better to add the appropriate types.
            String name = (String)keys.nextElement();
            String value = pmp.getProperty( name ).toString();

            Insert insert = new Insert();
            insert.setDatabaseConnectionPool( dcp )
                .setTable( "properties" )
                .addInteger( "reputation", table_properties_fk_reputation )
                .addInteger( "identifier", table_properties_fk_identifier )
                .addString( "name", name )
                .addString( "value", value )
                .addString( "type", "string" );

            insert.commit();

        }
        
    } 
    
    /**
     * Insert this reputation.
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: InsertReputation.java,v 1.9 2001/08/01 17:19:47 burton Exp $
     */
    public void commit() throws Exception {

        //FIXME: make sure this reputation (with this signature) does not already exist!!
        
        //only update if there are no properties already entered from this reputation.

        Select verify = new Select();

        verify.setDatabaseConnectionPool( dcp )
            .setTable( "reputations" )
            .addString( "uri", reputation.getURI().toString() );

        verify.commit();

        //determine if this payload should be added.
        if ( verify.getResultSet().next() == false ) {
        
            insertIntoReputationsTable( dcp );
            
            Enumeration payloads = reputation.getPayloads();
            
            while ( payloads.hasMoreElements() ) {
                
                Payload current = (Payload)payloads.nextElement();
                
                if ( sqe.supports( current ) ) {
                    
                    sqe.getLogger().message( "Indexing payload: " + current.getTypeReference() );
                    
                    //insert records into the identifiers table
                    insertIntoIdentifiersTable( dcp, current );                        
                    
                    //insert records into the properties table
                    insertIntoPropertiesTable( dcp, current );
                        
                } else {
                    
                    sqe.getLogger().warn( "The given payload is not supported: " + current.getTypeReference() );
                    
                }
                
            } 
        
        } else {

            sqe.getLogger().warn( "The given reputation already is already indexed: " + reputation.getURI() );

        }
    
    }

}

    

