/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $Id: SimpleQueryManager.java,v 1.12 2001/06/17 09:37:31 burton Exp $
 * $Project: http://sierra.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 *
 */

package org.openprivacy.sierra.query.talon.implementations.simple;


import java.io.*;
import java.net.*;
import java.util.*;
import org.openprivacy.sierra.query.*;
import org.openprivacy.sierra.query.talon.components.*;
import org.openprivacy.sierra.rce.talon.components.*;
import org.openprivacy.sierra.reputation.talon.components.*;
import org.openprivacy.sierra.store.talon.components.*;
import org.openprivacy.sierra.util.*;
import talon.*;
import talon.components.*;
import talon.util.net.*;

/**
 * @see QueryManager
 * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
 * @version $Id: SimpleQueryManager.java,v 1.12 2001/06/17 09:37:31 burton Exp $
 */
public class SimpleQueryManager extends BaseComponent implements Component, QueryManager {

    private Vector knownEngines = new Vector();
    
    public void init() throws TalonException {
        //add init code here

        //add the SimpleQueryEngine to the knownEngines

        knownEngines.addElement( ComponentFactory.getInstance( SimpleQueryEngine.class ) );
        
    }
    
    /**
     * @see QueryManager
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: SimpleQueryManager.java,v 1.12 2001/06/17 09:37:31 burton Exp $
     */
    public QueryEngine getQueryEngine( Query query ) throws QueryNotSupportedException {

        for ( int i = 0; i < knownEngines.size(); ++i ) {

            QueryEngine engine = (QueryEngine)knownEngines.elementAt( i );

            if ( engine.supports( query ) ) {
                return engine;
            } 
            
        }
        
        throw new QueryNotSupportedException();

    }

    /**
     * @see QueryManager
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: SimpleQueryManager.java,v 1.12 2001/06/17 09:37:31 burton Exp $
     */
    public void putReputation( Reputation reputation ) throws SierraException {

        for ( int i = 0; i < knownEngines.size(); ++i ) {

            QueryEngine qe = (QueryEngine)knownEngines.elementAt( i );

            qe.putReputation( reputation );

        } 
        
    }

    /**
     * @see QueryManager
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: SimpleQueryManager.java,v 1.12 2001/06/17 09:37:31 burton Exp $
     */
    public Result execute( Query query ) throws SierraException {

        return getQueryEngine( query ).execute( query );

    }

}

