/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $Id: SimpleQueryEngine.java,v 1.19 2001/07/03 07:55:19 burton Exp $
 * $Project: http://sierra.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 *
 */

package org.openprivacy.sierra.query.talon.implementations.simple;



import java.io.*;
import java.net.*;
import java.sql.*;
import java.util.*;
import org.openprivacy.sierra.query.*;
import org.openprivacy.sierra.query.talon.implementations.simple.util.*;
import org.openprivacy.sierra.query.talon.components.*;
import org.openprivacy.sierra.rce.talon.components.*;
import org.openprivacy.sierra.reputation.talon.implementations.*;
import org.openprivacy.sierra.reputation.talon.components.*;
import org.openprivacy.sierra.store.talon.components.*;
import org.openprivacy.sierra.util.*;
import org.openprivacy.sierra.util.SierraException;
import org.openprivacy.sierra.util.sql.*;
import talon.*;
import talon.components.*;
import talon.references.*;
import talon.util.net.*;

/**
 * @see QueryManager
 * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
 * @version $Id: SimpleQueryEngine.java,v 1.19 2001/07/03 07:55:19 burton Exp $
 */
public class SimpleQueryEngine extends BaseComponent implements Component, QueryEngine {

    public static final String SUPPORTED_PAYLOADS_KEY = "supported_payloads";
    

    //instance variables.

    private Vector supportedPayloads = new Vector();

    private DatabaseConnectionPool dcp = null;
    
    private Logger logger = null;
    
    public void init() throws TalonException {
        //add init code here

        this.logger = getLogger();
        
        System.out.println( "Adding supported payloads..." );

        URI pmpReference = TypeReferenceFactory.getTypeReference( PropertyManagerPayload.class );

        supportedPayloads.addElement( pmpReference );

        this.dcp = (DatabaseConnectionPool)ComponentFactory
            .getInstance( SierraResources.DATABASE_CONNNECTION_POOL );
        
    }

    
    /**
     * @see QueryEngine
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: SimpleQueryEngine.java,v 1.19 2001/07/03 07:55:19 burton Exp $
     */
    public Result execute( Query query ) throws SierraException {

        if ( supports( query ) ) {

            getLogger().message( "Going to execute query: "+ query.getTypeReference() );


            try {

                SelectReputation sr = new SelectReputation( dcp, (PropertyManager)query );
                sr.commit();

                return sr.getResult();
                
            } catch ( Throwable t ) {
                throw new SierraException( t );
            }
                
            
        } else {

            throw new QueryNotSupportedException();

        }
        
        
    }

    
    /**
     * Add a reputation for indexing...
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: SimpleQueryEngine.java,v 1.19 2001/07/03 07:55:19 burton Exp $
     */
    public void putReputation( Reputation reputation ) throws SierraException {

        logger.debug( "QueryEngine: putReputation " );
        
        //go over all payloads...

        //FIXME: noop.... not doing anything right now.
        
//          if ( supports( reputation ) ) {

//              //add this reputation to the database...

//              try { 

//                  //insert records into the reputations table

//                  new InsertReputation( dcp, reputation, this ).commit();
                
//              } catch ( Throwable t ) {
//                  throw new SierraException( t );
//              }
            
//          }  else {

//              logger.debug( "reputation not supported + " + reputation.toString() );
            
//              throw new SierraException( "The given Reputation is not supported." );

//          }
        
    }

    

    /**
     * @see QueryEngine
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: SimpleQueryEngine.java,v 1.19 2001/07/03 07:55:19 burton Exp $
     */
    public boolean supports( Reputation reputation ) {

        Enumeration enum = reputation.getPayloads();

        while ( enum.hasMoreElements() ) {

            Payload payload = (Payload)enum.nextElement();

            if ( supports( payload ) == false ) {
                return false;
            } 
            
        } 

        return true;
    }

    /**
     * @see QueryEngine
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: SimpleQueryEngine.java,v 1.19 2001/07/03 07:55:19 burton Exp $
     */
    public boolean supports( Payload payload ) {

        //if they are property payloads then we can index them.
        return this.supportedPayloads.contains( payload.getTypeReference() );

    }

    /**
     * @see QueryEngine
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: SimpleQueryEngine.java,v 1.19 2001/07/03 07:55:19 burton Exp $
     */
    public boolean supports( Query query ) {

        if ( query instanceof TargetedQuery ) {
            
            TargetedQuery tq = (TargetedQuery)query;

            return supportedPayloads.contains( tq.getPayloadIdentifier() );
            
        } 
        
        return false;

    }
    
}

    

