/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $Id: SimpleResult.java,v 1.3 2001/06/17 09:37:31 burton Exp $
 * $Project: http://sierra.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 *
 */

package org.openprivacy.sierra.query.talon.implementations;

import java.io.*;
import java.net.*;
import java.util.*;
import org.openprivacy.sierra.query.talon.components.*;
import org.openprivacy.sierra.reputation.talon.components.*;
import org.openprivacy.sierra.util.*;
import talon.*;
import talon.components.*;
import talon.util.net.*;

/**
 * @see Payload
 * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
 * @version $Id: SimpleResult.java,v 1.3 2001/06/17 09:37:31 burton Exp $
 */
public class SimpleResult extends BaseComponent implements Component, Result {

    private Vector reputations = new Vector();
    
    public void init() throws TalonException {
        //add init code here
    }


    /**
     * Get the Enumeration of reputations this results contains.
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: SimpleResult.java,v 1.3 2001/06/17 09:37:31 burton Exp $
     */
    public URI[] getReputations() {

        URI[] uris = new URI[ this.reputations.size() ];
        reputations.copyInto( uris );
        return uris;

    }


    /**
     * Add a reputation to this result.
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: SimpleResult.java,v 1.3 2001/06/17 09:37:31 burton Exp $
     */
    public void putReputation( URI reputation ) {

        this.reputations.addElement( reputation );

    }

    
}




