/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $Id: PropertyManagerTargetedQuery.java,v 1.6 2001/06/17 09:37:31 burton Exp $
 * $Project: http://sierra.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 *
 */

package org.openprivacy.sierra.query.talon.implementations;

import java.io.*;
import java.net.*;
import java.util.*;
import org.openprivacy.sierra.query.talon.components.*;
import org.openprivacy.sierra.reputation.talon.implementations.*;
import org.openprivacy.sierra.util.*;
import talon.*;
import talon.implementations.*;
import talon.components.*;
import talon.references.*;
import talon.util.*;
import talon.util.net.*;

/**
 * <p>
 * Defines a basic property matching mechanism for executing queries to match
 * certain results sets.  For example you could add a property here of "name",
 * "kevin" and if a reputation in a StoreEngine/QueryEngine had this match it
 * could return.
 *
 * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
 * @version $Id: PropertyManagerTargetedQuery.java,v 1.6 2001/06/17 09:37:31 burton Exp $
 */
public class PropertyManagerTargetedQuery extends BasePropertyManager
    implements Component, PropertyManager, TargetedQuery {

    private URI payloadIdentifier = null;
    
    public void init() throws TalonException {
        //add init code here
        
        this.setPayloadIdentifier( TypeReferenceFactory.getTypeReference( PropertyManagerPayload.class ) );

    }

    /**
     * @see TargetedQuery
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: PropertyManagerTargetedQuery.java,v 1.6 2001/06/17 09:37:31 burton Exp $
     */
    public void setPayloadIdentifier( URI payloadIdentifier ) { 
        this.payloadIdentifier = payloadIdentifier;
    }
    

    /**
     * @see TargetedQuery
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: PropertyManagerTargetedQuery.java,v 1.6 2001/06/17 09:37:31 burton Exp $
     */
    public URI getPayloadIdentifier() { 
        return this.payloadIdentifier;
    }
    
}




