/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $Id: CompositeQuery.java,v 1.5 2001/06/17 09:37:31 burton Exp $
 * $Project: http://sierra.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 *
 */

package org.openprivacy.sierra.query.talon.implementations;

import java.io.*;
import java.net.*;
import java.util.*;
import org.openprivacy.sierra.util.*;
import org.openprivacy.sierra.query.talon.components.*;
import talon.*;
import talon.components.*;
import talon.util.net.*;

/**
 * <p>
 * Basic Sierra component for nested Queries.  Each new query is added, each is
 * executed, and the results are combined.
 *
 * <p>
 * This may not be the best mechanism to use nested queries.  It is almost
 * impossible to combine results if they each has a sorting order within the
 * result. 
 *
 * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
 * @version $Id: CompositeQuery.java,v 1.5 2001/06/17 09:37:31 burton Exp $
 */
public class CompositeQuery extends BaseComponent implements Component, Query {

    private Vector queries = new Vector();
    
    public void init() throws TalonException {
        //add init code here
    }

    public Query[] getQueries() {

        Query[] queries = new Query[ this.queries.size() ];

        this.queries.copyInto( queries );

        return queries;
        
    }

    public void addQuery( Query query ) {
        this.queries.addElement( query );
    }
    
}




