/*
 * ---- 
 *
 * $Id: QueryManager.java,v 1.2 2001/03/21 20:59:33 burton Exp $
 * $Project: http://sierra.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * 
 */

/*
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package org.openprivacy.sierra.query.talon.components;


import java.io.*;
import java.net.*;
import java.util.*;
import org.openprivacy.sierra.query.*;
import org.openprivacy.sierra.rce.talon.components.*;
import org.openprivacy.sierra.store.talon.components.*;
import org.openprivacy.sierra.reputation.talon.components.*;
import org.openprivacy.sierra.util.*;
import talon.*;
import talon.components.*;
import talon.util.net.*;

/**
 * Handles determining which QueryEngine to use with a given RCE or StoreEngine.
 * The Query object is passed so that the QueryManager can return a QueryEngine
 * that is best optimized to execute this query.  Since an implementation of a
 * QueryEngine will be best optimized for a specific data format this is
 * necessary to figure out how to execute the query with the best possible
 * performance.  
 *
 * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
 * @version $Id: QueryManager.java,v 1.2 2001/03/21 20:59:33 burton Exp $
 */
public interface QueryManager extends Component {

    /**
     * 
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: QueryManager.java,v 1.2 2001/03/21 20:59:33 burton Exp $
     */
    public QueryEngine getQueryEngine( Query query ) throws QueryNotSupportedException;

    /**
     * Pass on the given reputation to all QueryEngines that support this.
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: QueryManager.java,v 1.2 2001/03/21 20:59:33 burton Exp $
     */
    public void putReputation( Reputation reputation ) throws SierraException;



    /**
     * Shortcut for: <code>getQueryEngine( query ).execute( query );</code>
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: QueryManager.java,v 1.2 2001/03/21 20:59:33 burton Exp $
     */
    public Result execute( Query query ) throws SierraException;

    
}


