/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $Id: QueryEngine.java,v 1.3 2001/06/17 09:37:31 burton Exp $
 * $Project: http://sierra.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 *
 */

package org.openprivacy.sierra.query.talon.components;

import java.io.*;
import java.net.*;
import java.security.*;
import java.util.*;
import org.openprivacy.sierra.rce.talon.components.*;
import org.openprivacy.sierra.reputation.talon.components.*;
import org.openprivacy.sierra.util.*;
import talon.*;
import talon.components.*;
import talon.util.net.*;

/**
 * Responsible for performing queries on StoreEngines.   QueryEngines are 
 * 
 * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
 * @version $Id: QueryEngine.java,v 1.3 2001/06/17 09:37:31 burton Exp $
 */
public interface QueryEngine extends Component {

    /**
     * Execute the given queries.
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: QueryEngine.java,v 1.3 2001/06/17 09:37:31 burton Exp $
     */
    public Result execute( Query query ) throws SierraException;

    /**
     * Give this QueryEngine this reputation so that it can index it.  Will/may
     * throw an Exception if it isn't supported (or has problems)
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: QueryEngine.java,v 1.3 2001/06/17 09:37:31 burton Exp $
     */
    public void putReputation( Reputation reputation )  throws SierraException;
    
    /**
     * Return true if this QueryEngine supports the given Reputation.
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: QueryEngine.java,v 1.3 2001/06/17 09:37:31 burton Exp $
     */
    public boolean supports( Reputation reputation );

    /**
     * Return true if this QueryEngine supports the given Query.
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: QueryEngine.java,v 1.3 2001/06/17 09:37:31 burton Exp $
     */
    public boolean supports( Query query );

    /**
     * Return true if this QueryEngine supports the given Payload.
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: QueryEngine.java,v 1.3 2001/06/17 09:37:31 burton Exp $
     */
    public boolean supports( Payload payload );


    
}
