/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $Id: SimpleNymFunctionProxy.java,v 1.10 2001/06/17 09:37:30 burton Exp $
 * $Project: http://sierra.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 *
 */

package org.openprivacy.sierra.nym.talon.implementations;

import java.io.*;
import java.net.*;
import java.security.*;
import java.util.*;
import org.openprivacy.sierra.nym.talon.components.*;
import org.openprivacy.sierra.util.*;
import talon.*;
import talon.components.*;
import talon.util.*;
import talon.util.net.*;

/**
 * Very basic NymFunctionProxy.  All it does is MD5 sign the objects so it is
 * not cryptographically valid.  
 *
 * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
 * @version $Id: SimpleNymFunctionProxy.java,v 1.10 2001/06/17 09:37:30 burton Exp $
 */
public class SimpleNymFunctionProxy extends BaseComponent implements Component, NymFunctionProxy {
    
    private Nym nym = null;
    
    /**
     * @see Component
     */
    public void init() throws TalonException { }

    /**
     * @see NymFunctionProxy
     * @version $Id: SimpleNymFunctionProxy.java,v 1.10 2001/06/17 09:37:30 burton Exp $
     */
    public Nym getNym() {
        return this.nym;
    }
    
    
    /**
     * @see NymFunctionProxy
     * @version $Id: SimpleNymFunctionProxy.java,v 1.10 2001/06/17 09:37:30 burton Exp $
     */
    public void setNym( Nym nym ) {
        this.nym = nym;
    }
                                       
    /**
     * @see NymFunctionProxy
     * @version $Id: SimpleNymFunctionProxy.java,v 1.10 2001/06/17 09:37:30 burton Exp $
     */
    public byte[] sign( Canonicalizable canon ) throws SierraException {

        try {
            
            MessageDigest md = MessageDigest.getInstance( "MD5" );

            return md.digest( canon.getCanonicalFormat() );

        } catch ( Exception jse ) {
            //catch all Java security exceptions
            throw new SierraException( jse );
        }

    }
    
    /**
     * @see NymFunctionProxy
     * @version $Id: SimpleNymFunctionProxy.java,v 1.10 2001/06/17 09:37:30 burton Exp $
     */
    public byte[] encrypt( Object obj ) throws SierraException {
        throw new RuntimeException( "Not implemented yet." );
    }
    
}

