/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $Id: SimpleNymBuilder.java,v 1.11 2001/06/17 09:37:30 burton Exp $
 * $Project: http://sierra.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 *
 */

package org.openprivacy.sierra.nym.talon.implementations;

import java.io.*;
import java.net.*;
import java.util.*;
import org.openprivacy.sierra.nym.talon.components.*;
import org.openprivacy.sierra.util.*;
import talon.*;
import talon.components.*;
import talon.util.*;
import talon.util.net.*;

/**
 * NymBuilder which uses URIs for keeping track of each other.  The PublicKey
 * from the Nym is just the URI.
 *
 * <p>
 * This component requires the following properties:
 *
 * <ul>
 * <li>nym_name:  String which represents the SimpleNymBuilder to create.
 * </ul>
 *
 * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
 * @version $Id: SimpleNymBuilder.java,v 1.11 2001/06/17 09:37:30 burton Exp $
 */
public class SimpleNymBuilder extends BaseComponent implements Component, NymBuilder {

    public static final String[] REQUIRED_PROPERTIES = { "nym_name" };

    /**
     * Default handle for creating a reputation object.
     */
    private ComponentHandle NYM_HANDLE =
        new ComponentHandle().setInterface( "org.openprivacy.sierra.nym.talon.components.Nym" )
                             .setImplementation( "org.openprivacy.sierra.nym.talon.implementations.SimpleNym" )
                             .setLifetime( ComponentHandle.LIFETIME_DEMAND );

    private ComponentHandle NYM_FUNCTION_PROXY_HANDLE =
        new ComponentHandle().setInterface( "org.openprivacy.sierra.nym.talon.components.NymFunctionProxy" )
                             .setImplementation( "org.openprivacy.sierra.nym.talon.implementations.SimpleNymFunctionProxy" )
                             .setLifetime( ComponentHandle.LIFETIME_DEMAND );

    private Nym nym = null;
    private NymFunctionProxy nfp = null;
    
    /**
     * initialize this...
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: SimpleNymBuilder.java,v 1.11 2001/06/17 09:37:30 burton Exp $
     */
    public void init() throws TalonException {

        //require specific properties.  This should throw an Exception if the
        //properties aren't available.
        this.getComponentHandle().getInitProperties().require( REQUIRED_PROPERTIES );
        
    }
    
    /**
     * @see NymBuilder
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: SimpleNymBuilder.java,v 1.11 2001/06/17 09:37:30 burton Exp $
     */
    public Nym getNym() throws SierraException {

        if ( nym == null ) {

            NYM_HANDLE.setInitProperties( this.getComponentHandle().getInitProperties() );
        
            try {
                nym =  (Nym)ComponentFactory.getInstance( NYM_HANDLE );
            } catch ( TalonException e ) {
                throw new SierraException( e );
            }
            
        } 
        
        return nym;

    }

    /**
     * @see NymBuilder
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: SimpleNymBuilder.java,v 1.11 2001/06/17 09:37:30 burton Exp $
     */
    public NymFunctionProxy getNymFunctionProxy() throws SierraException {

        if ( nfp == null ) {

            try {
                nfp =  (NymFunctionProxy)ComponentFactory.getInstance( NYM_FUNCTION_PROXY_HANDLE );
                nfp.setNym( this.getNym() );
            } catch ( TalonException e ) {
                throw new SierraException( e );
            }
            
        } 
        
        return nfp;
        
    }
    
}

