/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $Id: SimpleNym.java,v 1.10 2001/06/17 09:37:30 burton Exp $
 * $Project: http://sierra.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 *
 */

package org.openprivacy.sierra.nym.talon.implementations;

import java.security.*;
import java.util.*;
import org.openprivacy.sierra.nym.talon.components.*;
import talon.*;
import talon.components.*;
import talon.util.*;
import talon.util.net.*;

/**
 *
 * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
 * @version $Id: SimpleNym.java,v 1.10 2001/06/17 09:37:30 burton Exp $
 */
public class SimpleNym extends BaseComponent implements Component, Nym {

    public static final String NYM_NAME_KEY = "nym_name";
    
    public static final String[] REQUIRED_PROPERTIES = { NYM_NAME_KEY };

    private PublicKey publicKey = null;
    
    /**
     *
     * @exception talon.TalonException 
     */
    public void init() throws TalonException {
        
        //require specific properties
        this.getComponentHandle().getInitProperties().require( REQUIRED_PROPERTIES );

        this.publicKey = new SimplePublicKey( getName() );
        
    }
    
    /**
     * @see Nym
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: SimpleNym.java,v 1.10 2001/06/17 09:37:30 burton Exp $
     */
    public PublicKey getPublicKey() {
        return this.publicKey;
    }
    
    /**
     * @see Nym
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: SimpleNym.java,v 1.10 2001/06/17 09:37:30 burton Exp $
     */
    public Nym getNym() {
        return null;
    }

    /**
     * 
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: SimpleNym.java,v 1.10 2001/06/17 09:37:30 burton Exp $
     */
    public String getName() { 
        return this.getComponentHandle().getInitProperties().getString( NYM_NAME_KEY );
    }


    /**
     * @see Canonicalizable
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: SimpleNym.java,v 1.10 2001/06/17 09:37:30 burton Exp $
     */
    public byte[] getCanonicalFormat() {

        return getName().getBytes();
        
    }
}


/**
 * Simple Key impl.
 *
 * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
 * @version $Id: SimpleNym.java,v 1.10 2001/06/17 09:37:30 burton Exp $
 */
class SimplePublicKey implements PublicKey {

    private String name = null;
    
    public SimplePublicKey( String name ) {
        this.name = name;
    }
    
    public String getAlgorithm() {
        return "simple";
    }

    public byte[] getEncoded() {
        return name.getBytes();
    }

    public String getFormat() {
        return "simple";
    }

}
