/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $Id: NymFunctionProxy.java,v 1.4 2001/06/17 09:37:29 burton Exp $
 * $Project: http://sierra.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 *
 */

package org.openprivacy.sierra.nym.talon.components;

import java.io.*;
import java.net.*;
import java.security.*;
import java.util.*;
import org.openprivacy.sierra.util.*;
import talon.*;
import talon.components.*;
import talon.util.net.*;

/**
 * <p>
 * Because Sierra may operate in a Peer2Peer/distributed network, it is
 * important that privledged operations not cross the machine boundary.
 * Therefore the Nym component does not expose any special operations to outside
 * systems.  All data signing and encryption is handled in this dedicated
 * component. 
 *
 * <p>
 * In order to sign an object you must write it to return a canonicalized
 * representation of itself via toString().  Objects are passed to sign() and
 * encrypt() and if the output from toString is incorrect then the
 * signed/encrypted value will also be incorrct.
 * 
 * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
 * @version $Id: NymFunctionProxy.java,v 1.4 2001/06/17 09:37:29 burton Exp $
 */
public interface NymFunctionProxy extends Component {

    /**
     * Get the Nym which handles these functions.
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: NymFunctionProxy.java,v 1.4 2001/06/17 09:37:29 burton Exp $
     */
    public Nym getNym();
    
    /**
     * @see #getNym
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: NymFunctionProxy.java,v 1.4 2001/06/17 09:37:29 burton Exp $
     */
    public void setNym( Nym nym );

    /**
     * Sign an object.
     
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: NymFunctionProxy.java,v 1.4 2001/06/17 09:37:29 burton Exp $
     */
    public byte[] sign( Canonicalizable canon ) throws SierraException;

    /**
     * Encrypt an object.
     * 
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: NymFunctionProxy.java,v 1.4 2001/06/17 09:37:29 burton Exp $
     */
    public byte[] encrypt( Object obj ) throws SierraException;

}
