/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $Id: NymBuilder.java,v 1.3 2001/06/17 09:37:29 burton Exp $
 * $Project: http://sierra.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 *
 */

package org.openprivacy.sierra.nym.talon.components;

import java.io.*;
import java.net.*;
import java.util.*;
import org.openprivacy.sierra.util.*;
import talon.*;
import talon.components.*;
import talon.util.net.*;

/**
 * Responsible for creating Nyms.  After this component is created it will have
 * and internal Nym which you can obtain via getNym.
 * 
 * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
 * @version $Id: NymBuilder.java,v 1.3 2001/06/17 09:37:29 burton Exp $
 */
public interface NymBuilder extends Component {

    /**
     * Get the Nym created by this Nym builder.
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: NymBuilder.java,v 1.3 2001/06/17 09:37:29 burton Exp $
     */
    public Nym getNym() throws SierraException; 

    /**
     * Given a Nym, obtain its function proxy.
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: NymBuilder.java,v 1.3 2001/06/17 09:37:29 burton Exp $
     */
    public NymFunctionProxy getNymFunctionProxy() throws SierraException;
    
}
