/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $Id: Nym.java,v 1.4 2001/06/17 09:37:29 burton Exp $
 * $Project: http://sierra.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 *
 */

package org.openprivacy.sierra.nym.talon.components;

import java.io.*;
import java.net.*;
import java.security.*;
import java.util.*;
import org.openprivacy.sierra.util.*;
import talon.*;
import talon.components.*;
import talon.util.net.*;

/**
 * A nym implements the basic security system within Sierra. 
 * 
 * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
 * @version $Id: Nym.java,v 1.4 2001/06/17 09:37:29 burton Exp $
 */
public interface Nym extends Component, Principal, Canonicalizable {

    /**
     * Get the public key for this num.  Other components within the system can
     * use this as a handle for further operations.  
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: Nym.java,v 1.4 2001/06/17 09:37:29 burton Exp $
     */
    public PublicKey getPublicKey();

    /**
     * Get a Nym based on the current nym.  The parent nym needs to be able to
     * prove that it created the child nym.  A very simple mechanism can be used
     * so that this is easy to implement.  A more complex method could be used
     * with RSA.  The child could sign a message and hand it to its parent.
     * The parent could then present this message to prove that it is the
     * owner of this child.  
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: Nym.java,v 1.4 2001/06/17 09:37:29 burton Exp $
     */
    public Nym getNym();

}
