/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $Id: NymBuilderFactory.java,v 1.3 2001/06/17 09:37:29 burton Exp $
 * $Project: http://sierra.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 *
 */

package org.openprivacy.sierra.factories;

import java.io.*;
import java.net.*;
import java.security.Principal;
import java.util.*;

import org.openprivacy.sierra.nym.talon.components.*;
import org.openprivacy.sierra.rce.talon.components.*;
import org.openprivacy.sierra.reputation.talon.components.*;
import org.openprivacy.sierra.util.*;

import talon.*;
import talon.components.*;
import talon.util.net.*;

/**
 * Get the registered Talon Component "Reference" with a "demand" lifetime.
 *
 * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
 * @version $Id: NymBuilderFactory.java,v 1.3 2001/06/17 09:37:29 burton Exp $
 */
public class NymBuilderFactory {

    public static NymBuilder getInstance( String name ) throws SierraException {

        ComponentHandle handle = new ComponentHandle();

        handle.setName( "talon:///component-name/product/sierra/name/nym_builder" );

        handle.getInitProperties().setString( "nym_name", name );

        NymBuilder nb = null;
        
        try {

            nb = (NymBuilder)ComponentFactory.getInstance( handle ); 

        } catch ( TalonException te ) {

            te.printStackTrace();
            
            throw new SierraException( te );

        }

        return nb;
        
    }


}
